/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.instrument.opentracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.opentracingshim.OpenTracingShim;
import io.opentracing.Tracer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthOpentracingProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.opentracing.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OpenTelemetry.class})
@ConditionalOnClass(value={OpenTracingShim.class})
@AutoConfigureAfter(value={OtelAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthOpentracingProperties.class})
public class OtelOpentracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    Tracer sleuthOpenTracing(OpenTelemetry openTelemetry) {
        return OpenTracingShim.createTracerShim((OpenTelemetry)openTelemetry);
    }
}

