/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.springframework.cloud.skipper.domain.AbstractEntity;

@Entity
@Table(name="SkipperRepository", uniqueConstraints={@UniqueConstraint(name="uk_repository", columnNames={"name"})}, indexes={@Index(name="idx_repo_name", columnList="name")})
public class Repository
extends AbstractEntity {
    @NotNull
    private String name;
    @NotNull
    @Lob
    @Type(type="org.springframework.cloud.dataflow.common.persistence.type.DatabaseAwareLobType")
    private String url;
    @Lob
    @Type(type="org.springframework.cloud.dataflow.common.persistence.type.DatabaseAwareLobType")
    private String sourceUrl;
    private Boolean local = false;
    private String description;
    private Integer repoOrder;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getRepoOrder() {
        return this.repoOrder;
    }

    public void setRepoOrder(Integer repoOrder) {
        this.repoOrder = repoOrder;
    }

    public String toString() {
        return "Repository{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", local=" + this.local + '}';
    }
}

