/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.schema.registry.client.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.schema.registry.client.CachingRegistryClient;
import org.springframework.cloud.schema.registry.client.DefaultSchemaRegistryClient;
import org.springframework.cloud.schema.registry.client.SchemaRegistryClient;
import org.springframework.cloud.schema.registry.client.config.SchemaRegistryClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={SchemaRegistryClientProperties.class})
public class SchemaRegistryClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SchemaRegistryClient schemaRegistryClient(SchemaRegistryClientProperties schemaRegistryClientProperties) {
        DefaultSchemaRegistryClient defaultSchemaRegistryClient = new DefaultSchemaRegistryClient();
        if (StringUtils.hasText((String)schemaRegistryClientProperties.getEndpoint())) {
            defaultSchemaRegistryClient.setEndpoint(schemaRegistryClientProperties.getEndpoint());
        }
        SchemaRegistryClient client = schemaRegistryClientProperties.isCached() ? new CachingRegistryClient(defaultSchemaRegistryClient) : defaultSchemaRegistryClient;
        return client;
    }
}

