/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;

public abstract class AbstractRibbonCommandFactory
implements RibbonCommandFactory {
    private Map<String, FallbackProvider> fallbackProviderCache = new HashMap<String, FallbackProvider>();
    private FallbackProvider defaultFallbackProvider = null;

    public AbstractRibbonCommandFactory(Set<FallbackProvider> fallbackProviders) {
        for (FallbackProvider provider : fallbackProviders) {
            String route = provider.getRoute();
            if ("*".equals(route) || route == null) {
                this.defaultFallbackProvider = provider;
                continue;
            }
            this.fallbackProviderCache.put(route, provider);
        }
    }

    protected FallbackProvider getFallbackProvider(String route) {
        FallbackProvider provider = this.fallbackProviderCache.get(route);
        if (provider == null) {
            provider = this.defaultFallbackProvider;
        }
        return provider;
    }
}

