/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import com.netflix.hystrix.HystrixCommand;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;

public class HystrixCircuitBreaker
implements CircuitBreaker {
    private HystrixCommand.Setter setter;

    public HystrixCircuitBreaker(HystrixCommand.Setter setter) {
        this.setter = setter;
    }

    public <T> T run(final Supplier<T> toRun, final Function<Throwable, T> fallback) {
        HystrixCommand command = new HystrixCommand<T>(this.setter){

            protected T run() throws Exception {
                return toRun.get();
            }

            protected T getFallback() {
                return fallback.apply(this.getExecutionException());
            }
        };
        return (T)command.execute();
    }
}

