/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix.stream;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.hystrix.stream.HystrixStreamProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.Assert;

public class HystrixStreamTask
implements ApplicationContextAware {
    private static Log log = LogFactory.getLog(HystrixStreamTask.class);
    private MessageChannel outboundChannel;
    private ServiceInstance registration;
    private HystrixStreamProperties properties;
    private ApplicationContext context;
    final LinkedBlockingQueue<String> jsonMetrics;
    private final JsonFactory jsonFactory = new JsonFactory();

    public HystrixStreamTask(MessageChannel outboundChannel, ServiceInstance registration, HystrixStreamProperties properties) {
        Assert.notNull((Object)outboundChannel, (String)"outboundChannel may not be null");
        Assert.notNull((Object)registration, (String)"registration may not be null");
        Assert.notNull((Object)properties, (String)"properties may not be null");
        this.outboundChannel = outboundChannel;
        this.registration = registration;
        this.properties = properties;
        this.jsonMetrics = new LinkedBlockingQueue(properties.getSize());
    }

    ServiceInstance getRegistration() {
        return this.registration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Scheduled(fixedRateString="${hystrix.stream.queue.sendRate:${hystrix.stream.queue.send-rate:500}}")
    public void sendMetrics() {
        ArrayList metrics = new ArrayList();
        this.jsonMetrics.drainTo(metrics);
        if (!metrics.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("sending stream metrics size: " + metrics.size()));
            }
            for (String json : metrics) {
                try {
                    this.outboundChannel.send(MessageBuilder.withPayload((Object)json).setHeader("contentType", (Object)this.properties.getContentType()).build());
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("failed sending stream metrics: " + ex.getMessage()));
                }
            }
        }
    }

    @Scheduled(fixedRateString="${hystrix.stream.queue.gatherRate:${hystrix.stream.queue.gather-rate:500}}")
    public void gatherMetrics() {
        try {
            HystrixCommandKey key;
            Collection instances = HystrixCommandMetrics.getInstances();
            if (!instances.isEmpty()) {
                log.trace((Object)("gathering metrics size: " + instances.size()));
            }
            for (HystrixCommandMetrics commandMetrics : instances) {
                key = commandMetrics.getCommandKey();
                HystrixCircuitBreaker circuitBreaker = HystrixCircuitBreaker.Factory.getInstance((HystrixCommandKey)key);
                StringWriter jsonString = new StringWriter();
                JsonGenerator json = this.jsonFactory.createGenerator((Writer)jsonString);
                json.writeStartObject();
                this.addServiceData(json, this.registration);
                json.writeStringField("event", "message");
                json.writeObjectFieldStart("data");
                json.writeStringField("type", "HystrixCommand");
                String name = key.name();
                if (this.properties.isPrefixMetricName() && this.registration != null) {
                    name = this.registration.getServiceId() + "." + name;
                }
                json.writeStringField("name", name);
                json.writeStringField("group", commandMetrics.getCommandGroup().name());
                json.writeNumberField("currentTime", System.currentTimeMillis());
                if (circuitBreaker == null) {
                    json.writeBooleanField("isCircuitBreakerOpen", false);
                } else {
                    json.writeBooleanField("isCircuitBreakerOpen", circuitBreaker.isOpen());
                }
                HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
                json.writeNumberField("errorPercentage", healthCounts.getErrorPercentage());
                json.writeNumberField("errorCount", healthCounts.getErrorCount());
                json.writeNumberField("requestCount", healthCounts.getTotalRequests());
                json.writeNumberField("rollingCountCollapsedRequests", commandMetrics.getRollingCount(HystrixRollingNumberEvent.COLLAPSED));
                json.writeNumberField("rollingCountExceptionsThrown", commandMetrics.getRollingCount(HystrixRollingNumberEvent.EXCEPTION_THROWN));
                json.writeNumberField("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
                json.writeNumberField("rollingCountFallbackFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_FAILURE));
                json.writeNumberField("rollingCountFallbackRejection", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_REJECTION));
                json.writeNumberField("rollingCountFallbackSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FALLBACK_SUCCESS));
                json.writeNumberField("rollingCountResponsesFromCache", commandMetrics.getRollingCount(HystrixRollingNumberEvent.RESPONSE_FROM_CACHE));
                json.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
                json.writeNumberField("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
                json.writeNumberField("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
                json.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
                json.writeNumberField("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
                json.writeNumberField("currentConcurrentExecutionCount", commandMetrics.getCurrentConcurrentExecutionCount());
                json.writeNumberField("latencyExecute_mean", commandMetrics.getExecutionTimeMean());
                json.writeObjectFieldStart("latencyExecute");
                json.writeNumberField("0", commandMetrics.getExecutionTimePercentile(0.0));
                json.writeNumberField("25", commandMetrics.getExecutionTimePercentile(25.0));
                json.writeNumberField("50", commandMetrics.getExecutionTimePercentile(50.0));
                json.writeNumberField("75", commandMetrics.getExecutionTimePercentile(75.0));
                json.writeNumberField("90", commandMetrics.getExecutionTimePercentile(90.0));
                json.writeNumberField("95", commandMetrics.getExecutionTimePercentile(95.0));
                json.writeNumberField("99", commandMetrics.getExecutionTimePercentile(99.0));
                json.writeNumberField("99.5", commandMetrics.getExecutionTimePercentile(99.5));
                json.writeNumberField("100", commandMetrics.getExecutionTimePercentile(100.0));
                json.writeEndObject();
                json.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
                json.writeObjectFieldStart("latencyTotal");
                json.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
                json.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
                json.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
                json.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
                json.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
                json.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
                json.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
                json.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
                json.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
                json.writeEndObject();
                HystrixCommandProperties commandProperties = commandMetrics.getProperties();
                json.writeNumberField("propertyValue_circuitBreakerRequestVolumeThreshold", ((Integer)commandProperties.circuitBreakerRequestVolumeThreshold().get()).intValue());
                json.writeNumberField("propertyValue_circuitBreakerSleepWindowInMilliseconds", ((Integer)commandProperties.circuitBreakerSleepWindowInMilliseconds().get()).intValue());
                json.writeNumberField("propertyValue_circuitBreakerErrorThresholdPercentage", ((Integer)commandProperties.circuitBreakerErrorThresholdPercentage().get()).intValue());
                json.writeBooleanField("propertyValue_circuitBreakerForceOpen", ((Boolean)commandProperties.circuitBreakerForceOpen().get()).booleanValue());
                json.writeBooleanField("propertyValue_circuitBreakerForceClosed", ((Boolean)commandProperties.circuitBreakerForceClosed().get()).booleanValue());
                json.writeBooleanField("propertyValue_circuitBreakerEnabled", ((Boolean)commandProperties.circuitBreakerEnabled().get()).booleanValue());
                json.writeStringField("propertyValue_executionIsolationStrategy", ((HystrixCommandProperties.ExecutionIsolationStrategy)commandProperties.executionIsolationStrategy().get()).name());
                json.writeNumberField("propertyValue_executionIsolationThreadTimeoutInMilliseconds", ((Integer)commandProperties.executionIsolationThreadTimeoutInMilliseconds().get()).intValue());
                json.writeBooleanField("propertyValue_executionIsolationThreadInterruptOnTimeout", ((Boolean)commandProperties.executionIsolationThreadInterruptOnTimeout().get()).booleanValue());
                json.writeStringField("propertyValue_executionIsolationThreadPoolKeyOverride", (String)commandProperties.executionIsolationThreadPoolKeyOverride().get());
                json.writeNumberField("propertyValue_executionIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.executionIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
                json.writeNumberField("propertyValue_fallbackIsolationSemaphoreMaxConcurrentRequests", ((Integer)commandProperties.fallbackIsolationSemaphoreMaxConcurrentRequests().get()).intValue());
                json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)commandProperties.metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
                json.writeBooleanField("propertyValue_requestCacheEnabled", ((Boolean)commandProperties.requestCacheEnabled().get()).booleanValue());
                json.writeBooleanField("propertyValue_requestLogEnabled", ((Boolean)commandProperties.requestLogEnabled().get()).booleanValue());
                json.writeNumberField("reportingHosts", 1);
                json.writeEndObject();
                json.writeEndObject();
                json.close();
                this.jsonMetrics.add(jsonString.getBuffer().toString());
            }
            for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
                key = threadPoolMetrics.getThreadPoolKey();
                StringWriter jsonString = new StringWriter();
                JsonGenerator json = this.jsonFactory.createGenerator((Writer)jsonString);
                json.writeStartObject();
                this.addServiceData(json, this.registration);
                json.writeObjectFieldStart("data");
                json.writeStringField("type", "HystrixThreadPool");
                json.writeStringField("name", key.name());
                json.writeNumberField("currentTime", System.currentTimeMillis());
                json.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
                json.writeNumberField("currentCompletedTaskCount", threadPoolMetrics.getCurrentCompletedTaskCount().longValue());
                json.writeNumberField("currentCorePoolSize", threadPoolMetrics.getCurrentCorePoolSize().intValue());
                json.writeNumberField("currentLargestPoolSize", threadPoolMetrics.getCurrentLargestPoolSize().intValue());
                json.writeNumberField("currentMaximumPoolSize", threadPoolMetrics.getCurrentMaximumPoolSize().intValue());
                json.writeNumberField("currentPoolSize", threadPoolMetrics.getCurrentPoolSize().intValue());
                json.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
                json.writeNumberField("currentTaskCount", threadPoolMetrics.getCurrentTaskCount().longValue());
                json.writeNumberField("rollingCountThreadsExecuted", threadPoolMetrics.getRollingCountThreadsExecuted());
                json.writeNumberField("rollingMaxActiveThreads", threadPoolMetrics.getRollingMaxActiveThreads());
                json.writeNumberField("propertyValue_queueSizeRejectionThreshold", ((Integer)threadPoolMetrics.getProperties().queueSizeRejectionThreshold().get()).intValue());
                json.writeNumberField("propertyValue_metricsRollingStatisticalWindowInMilliseconds", ((Integer)threadPoolMetrics.getProperties().metricsRollingStatisticalWindowInMilliseconds().get()).intValue());
                json.writeNumberField("reportingHosts", 1);
                json.writeEndObject();
                json.writeEndObject();
                json.close();
                this.jsonMetrics.add(jsonString.getBuffer().toString());
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error adding metrics to queue", (Throwable)ex);
        }
    }

    private void addServiceData(JsonGenerator json, ServiceInstance localService) throws IOException {
        json.writeObjectFieldStart("origin");
        json.writeStringField("host", localService.getHost());
        json.writeNumberField("port", localService.getPort());
        json.writeStringField("serviceId", localService.getServiceId());
        if (this.properties.isSendId()) {
            json.writeStringField("id", this.context.getId());
        }
        json.writeEndObject();
    }
}

