/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.appinfo.MyDataCenterInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.converters.jackson.DataCenterTypeInfoResolver;
import com.netflix.discovery.converters.jackson.builder.ApplicationsJacksonBuilder;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.AsyncResolver;
import com.netflix.discovery.shared.resolver.DefaultEndpoint;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.shared.transport.decorator.RetryableEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.SessionedEurekaHttpClient;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.util.ClassUtils;

class EurekaClientHints
implements RuntimeHintsRegistrar {
    EurekaClientHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"com.netflix.discovery.DiscoveryClient", (ClassLoader)classLoader)) {
            return;
        }
        hints.reflection().registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{ApplicationInfoManager.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INTROSPECT_DECLARED_METHODS})).registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{DiscoveryClient.class, EurekaHttpClientDecorator.class, InstanceInfo.ActionType.class, InstanceInfoJsonMixIn.class, SessionedEurekaHttpClient.class, RetryableEurekaHttpClient.class, AsyncResolver.class, Applications.class, TimedSupervisorTask.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INTROSPECT_DECLARED_METHODS})).registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{EurekaEndpoint.class, EurekaHttpClientDecorator.RequestExecutor.class, EurekaClient.class, DiscoveryClient.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS})).registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{DataCenterTypeInfoResolver.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS})).registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{Application.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS})).registerTypes((Iterable)TypeReference.listOf((Class[])new Class[]{DefaultEndpoint.class, EurekaHttpResponse.class, InstanceInfo.class, InstanceInfo.PortWrapper.class, LeaseInfo.class, MyDataCenterInfo.class, DataCenterInfo.class, DataCenterInfo.Name.class, ApplicationsJacksonBuilder.class, EurekaServiceInstance.class}), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
    }
}

