/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.loadbalancer.core.BlockingLoadBalancerApiVersionStrategy;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.LoadBalancerHttpServletRequest;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.ApiVersionResolver;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.MediaTypeParamApiVersionResolver;
import org.springframework.web.accept.PathApiVersionResolver;
import org.springframework.web.accept.QueryApiVersionResolver;
import reactor.core.publisher.Flux;

public class BlockingApiVersionServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    public static final String API_VERSION = "API_VERSION";
    private static final Log LOG = LogFactory.getLog(BlockingApiVersionServiceInstanceListSupplier.class);
    private final boolean callGetWithRequestOnDelegates;
    private final LoadBalancerProperties.ApiVersion apiVersionProperties;
    private final LoadBalancerClientFactory loadBalancerClientFactory;
    private ApiVersionParser<?> apiVersionParser;
    private ApiVersionStrategy apiVersionStrategy;

    public BlockingApiVersionServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerClientFactory loadBalancerClientFactory) {
        super(delegate);
        String serviceId = this.getServiceId();
        this.loadBalancerClientFactory = loadBalancerClientFactory;
        LoadBalancerProperties properties = loadBalancerClientFactory.getProperties(serviceId);
        this.callGetWithRequestOnDelegates = properties.isCallGetWithRequestOnDelegates();
        this.apiVersionProperties = properties.getApiVersion();
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        Object requestContext = request.getContext();
        if (this.callGetWithRequestOnDelegates && requestContext instanceof RequestDataContext) {
            RequestDataContext requestDataContext = (RequestDataContext)requestContext;
            return this.getDelegate().get(request).map(serviceInstances -> this.filteredByVersion((List<ServiceInstance>)serviceInstances, this.getVersionFromRequest(requestDataContext.getClientRequest())));
        }
        return this.get();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        Comparable defaultVersion = this.getApiVersionStrategy().getDefaultVersion();
        return ((Flux)this.getDelegate().get()).map(serviceInstances -> this.filteredByVersion((List<ServiceInstance>)serviceInstances, defaultVersion));
    }

    private List<ServiceInstance> filteredByVersion(List<ServiceInstance> serviceInstances, Comparable<?> requestedVersion) {
        List<ServiceInstance> filteredInstances;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Matching instances by API Version: " + String.valueOf(requestedVersion)));
        }
        if (requestedVersion != null && !(filteredInstances = serviceInstances.parallelStream().filter(instance -> requestedVersion.equals(this.getVersion((ServiceInstance)instance))).toList()).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found matching instances by API Version: " + String.valueOf(filteredInstances)));
            }
            return filteredInstances;
        }
        if (this.apiVersionProperties.isFallbackToAvailableInstances()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No matching instances found by API Version: " + String.valueOf(requestedVersion) + ". Falling back to all available instances."));
            }
            return serviceInstances;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No matching instances found by API Version: " + String.valueOf(requestedVersion) + ". Returning empty list."));
        }
        return List.of();
    }

    void setApiVersionParser(ApiVersionParser<?> apiVersionParser) {
        this.apiVersionParser = apiVersionParser;
    }

    private Comparable<?> getVersionFromRequest(RequestData requestData) {
        LoadBalancerHttpServletRequest servletRequest = new LoadBalancerHttpServletRequest(requestData);
        Comparable apiVersion = this.getApiVersionStrategy().resolveParseAndValidateVersion((HttpServletRequest)servletRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resolved API Version from request: " + String.valueOf(apiVersion)));
        }
        return apiVersion;
    }

    private Comparable<?> getVersion(ServiceInstance serviceInstance) {
        String version;
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null && (version = (String)metadata.get(API_VERSION)) != null) {
            return this.getApiVersionStrategy().parseVersion(version);
        }
        return null;
    }

    private ApiVersionParser getApiVersionParser() {
        if (this.apiVersionParser == null) {
            this.apiVersionParser = (ApiVersionParser)this.loadBalancerClientFactory.getInstance(this.getServiceId(), ApiVersionParser.class);
        }
        return this.apiVersionParser;
    }

    private ApiVersionStrategy getApiVersionStrategy() {
        if (this.apiVersionStrategy == null) {
            ApiVersionStrategy userProvidedApiVersionStrategy = (ApiVersionStrategy)this.loadBalancerClientFactory.getInstance(this.getServiceId(), ApiVersionStrategy.class);
            this.apiVersionStrategy = userProvidedApiVersionStrategy != null ? userProvidedApiVersionStrategy : this.buildApiVersionStrategy();
        }
        return this.apiVersionStrategy;
    }

    private ApiVersionStrategy buildApiVersionStrategy() {
        ArrayList<ApiVersionResolver> versionResolvers = new ArrayList<ApiVersionResolver>();
        if (StringUtils.hasText((String)this.apiVersionProperties.getHeader())) {
            versionResolvers.add(request -> request.getHeader(this.apiVersionProperties.getHeader()));
        }
        if (StringUtils.hasText((String)this.apiVersionProperties.getQueryParameter())) {
            versionResolvers.add((ApiVersionResolver)new QueryApiVersionResolver(this.apiVersionProperties.getQueryParameter()));
        }
        if (this.apiVersionProperties.getPathSegment() != null) {
            versionResolvers.add((ApiVersionResolver)new PathApiVersionResolver(this.apiVersionProperties.getPathSegment().intValue()));
        }
        this.apiVersionProperties.getMediaTypeParameters().forEach((mediaType, paramName) -> versionResolvers.add((ApiVersionResolver)new MediaTypeParamApiVersionResolver(mediaType, paramName)));
        return new BlockingLoadBalancerApiVersionStrategy(versionResolvers, this.getApiVersionParser(), this.apiVersionProperties.getRequired(), this.apiVersionProperties.getDefaultVersion(), false, null, null);
    }
}

