/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class ZonePreferenceServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final String ZONE = "zone";
    private final LoadBalancerZoneConfig zoneConfig;
    private String zone;
    private boolean callGetWithRequestOnDelegates;

    public ZonePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerZoneConfig zoneConfig) {
        super(delegate);
        this.zoneConfig = zoneConfig;
    }

    public ZonePreferenceServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerZoneConfig zoneConfig, ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerClientFactory) {
        super(delegate);
        this.zoneConfig = zoneConfig;
        this.callGetWithRequestOnDelegates = loadBalancerClientFactory.getProperties(this.getServiceId()).isCallGetWithRequestOnDelegates();
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return ((Flux)this.getDelegate().get()).map(this::filteredByZone);
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        if (this.callGetWithRequestOnDelegates) {
            return this.getDelegate().get(request).map(this::filteredByZone);
        }
        return this.get();
    }

    private List<ServiceInstance> filteredByZone(List<ServiceInstance> serviceInstances) {
        if (this.zone == null) {
            this.zone = this.zoneConfig.getZone();
        }
        if (this.zone != null) {
            ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
            for (ServiceInstance serviceInstance : serviceInstances) {
                String instanceZone = this.getZone(serviceInstance);
                if (!this.zone.equalsIgnoreCase(instanceZone)) continue;
                filteredInstances.add(serviceInstance);
            }
            if (filteredInstances.size() > 0) {
                return filteredInstances;
            }
        }
        return serviceInstances;
    }

    private String getZone(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        if (metadata != null) {
            return (String)metadata.get(ZONE);
        }
        return null;
    }
}

