/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.blocking.client;

import java.io.IOException;
import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.Response;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class BlockingLoadBalancerClient
implements LoadBalancerClient {
    private final LoadBalancerClientFactory loadBalancerClientFactory;

    public BlockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory) {
        this.loadBalancerClientFactory = loadBalancerClientFactory;
    }

    public <T> T execute(String serviceId, LoadBalancerRequest<T> request) throws IOException {
        ServiceInstance serviceInstance = this.choose(serviceId);
        if (serviceInstance == null) {
            throw new IllegalStateException("No instances available for " + serviceId);
        }
        return this.execute(serviceId, serviceInstance, request);
    }

    public <T> T execute(String serviceId, ServiceInstance serviceInstance, LoadBalancerRequest<T> request) throws IOException {
        try {
            return (T)request.apply(serviceInstance);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            return null;
        }
    }

    public URI reconstructURI(ServiceInstance serviceInstance, URI original) {
        return LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)original);
    }

    public ServiceInstance choose(String serviceId) {
        ReactiveLoadBalancer<ServiceInstance> loadBalancer = this.loadBalancerClientFactory.getInstance(serviceId);
        if (loadBalancer == null) {
            return null;
        }
        Response loadBalancerResponse = (Response)Mono.from((Publisher)loadBalancer.choose()).block();
        if (loadBalancerResponse == null) {
            return null;
        }
        return (ServiceInstance)loadBalancerResponse.getServer();
    }
}

