/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.stoyanr.evictor.ConcurrentMapWithTimedEviction;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.loadbalancer.reactive.OnNoRibbonDefaultCondition;
import org.springframework.cloud.loadbalancer.cache.CaffeineBasedLoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.DefaultLoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CacheManager.class, CacheAutoConfiguration.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.loadbalancer.cache.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={LoadBalancerCacheProperties.class})
@Conditional(value={OnNoRibbonDefaultCondition.class})
public class LoadBalancerCacheAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"com.github.benmanes.caffeine.cache.Caffeine"})
    @ConditionalOnClass(value={ConcurrentMapWithTimedEviction.class})
    protected static class DefaultLoadBalancerCacheManagerConfiguration {
        protected DefaultLoadBalancerCacheManagerConfiguration() {
        }

        @Bean(autowireCandidate=false)
        @ConditionalOnMissingBean
        LoadBalancerCacheManager defaultLoadBalancerCacheManager(LoadBalancerCacheProperties cacheProperties) {
            return new DefaultLoadBalancerCacheManager(cacheProperties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Caffeine.class})
    protected static class CaffeineLoadBalancerCacheManagerConfiguration {
        protected CaffeineLoadBalancerCacheManagerConfiguration() {
        }

        @Bean(autowireCandidate=false)
        @ConditionalOnMissingBean
        LoadBalancerCacheManager caffeineLoadBalancerCacheManager(LoadBalancerCacheProperties cacheProperties) {
            return new CaffeineBasedLoadBalancerCacheManager(cacheProperties);
        }
    }

    static class LoadBalancerCaffeineWarnLogger {
        private static final Log LOG = LogFactory.getLog(LoadBalancerCaffeineWarnLogger.class);

        LoadBalancerCaffeineWarnLogger() {
        }

        @PostConstruct
        void logWarning() {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Spring Cloud LoadBalancer is currently working with default default cache. You can switch to using Caffeine cache, by adding it to the classpath.");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"com.github.benmanes.caffeine.cache.Caffeine"})
    protected static class LoadBalancerCacheManagerWarnConfiguration {
        protected LoadBalancerCacheManagerWarnConfiguration() {
        }

        @Bean
        LoadBalancerCaffeineWarnLogger caffeineWarnLogger() {
            return new LoadBalancerCaffeineWarnLogger();
        }
    }
}

