/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.annotation;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceSupplier;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LoadBalancerProperties.class})
@ConditionalOnDiscoveryEnabled
public class LoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    @ConditionalOnMissingBean
    LoadBalancerProperties loadBalancerProperties() {
        return new LoadBalancerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactorLoadBalancer<ServiceInstance> reactorServiceInstanceLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RoundRobinLoadBalancer((ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    public static class BlockingSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(DiscoveryClient discoveryClient, Environment env, ApplicationContext context) {
            DiscoveryClientServiceInstanceListSupplier delegate = new DiscoveryClientServiceInstanceListSupplier(discoveryClient, env);
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceListSupplier(delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            return delegate;
        }

        @Bean
        @ConditionalOnBean(value={DiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceSupplier discoveryClientServiceInstanceSupplier(DiscoveryClient discoveryClient, Environment env, ApplicationContext context) {
            DiscoveryClientServiceInstanceSupplier delegate = new DiscoveryClientServiceInstanceSupplier(discoveryClient, env);
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceSupplier(delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            return delegate;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    public static class ReactiveSupportConfiguration {
        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceListSupplier discoveryClientServiceInstanceListSupplier(ReactiveDiscoveryClient discoveryClient, Environment env, ApplicationContext context) {
            DiscoveryClientServiceInstanceListSupplier delegate = new DiscoveryClientServiceInstanceListSupplier(discoveryClient, env);
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceListSupplier(delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            return delegate;
        }

        @Bean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        @ConditionalOnMissingBean
        public ServiceInstanceSupplier discoveryClientServiceInstanceSupplier(ReactiveDiscoveryClient discoveryClient, Environment env, ApplicationContext context) {
            DiscoveryClientServiceInstanceSupplier delegate = new DiscoveryClientServiceInstanceSupplier(discoveryClient, env);
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceSupplier(delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            return delegate;
        }
    }
}

