/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.loadbalancer;

import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.loadbalancer.ConditionalOnKubernetesLoadBalancerEnabled;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesLoadBalancerProperties;
import org.springframework.cloud.kubernetes.fabric8.loadbalancer.Fabric8LoadBalancerClientConfiguration;
import org.springframework.cloud.kubernetes.fabric8.loadbalancer.Fabric8ServiceInstanceMapper;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={KubernetesLoadBalancerProperties.class})
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnKubernetesLoadBalancerEnabled
@LoadBalancerClients(defaultConfiguration={Fabric8LoadBalancerClientConfiguration.class})
public class Fabric8LoadBalancerAutoConfiguration {
    @Bean
    Fabric8ServiceInstanceMapper mapper(KubernetesLoadBalancerProperties properties, KubernetesDiscoveryProperties discoveryProperties) {
        return new Fabric8ServiceInstanceMapper(properties, discoveryProperties);
    }
}

