/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.profile;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import org.springframework.cloud.kubernetes.commons.profile.AbstractKubernetesProfileEnvironmentPostProcessor;
import org.springframework.cloud.kubernetes.fabric8.Fabric8PodUtils;
import org.springframework.core.env.Environment;

public class Fabric8ProfileEnvironmentPostProcessor
extends AbstractKubernetesProfileEnvironmentPostProcessor {
    protected boolean isInsideKubernetes(Environment environment) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            Fabric8PodUtils podUtils = new Fabric8PodUtils(client);
            boolean bl = environment.containsProperty("KUBERNETES_SERVICE_HOST") || podUtils.isInsideKubernetes();
            return bl;
        }
    }
}

