/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.Fabric8PodUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesEnabled
@AutoConfigureAfter(value={KubernetesCommonsAutoConfiguration.class})
public class Fabric8AutoConfiguration {
    private static final Log LOG = LogFactory.getLog(Fabric8AutoConfiguration.class);

    private static <D> D or(D left, D right) {
        return left != null ? left : right;
    }

    private static Integer orDurationInt(Duration left, Integer right) {
        return left != null ? (int)left.toMillis() : right;
    }

    private static Long orDurationLong(Duration left, Long right) {
        return left != null ? left.toMillis() : right.longValue();
    }

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public Config kubernetesClientConfig(KubernetesClientProperties kubernetesClientProperties) {
        Config base = Config.autoConfigure(null);
        Config properties = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(Fabric8AutoConfiguration.or(kubernetesClientProperties.getMasterUrl(), base.getMasterUrl()))).withApiVersion(Fabric8AutoConfiguration.or(kubernetesClientProperties.getApiVersion(), base.getApiVersion()))).withNamespace(Fabric8AutoConfiguration.or(kubernetesClientProperties.getNamespace(), base.getNamespace()))).withUsername(Fabric8AutoConfiguration.or(kubernetesClientProperties.getUsername(), base.getUsername()))).withPassword(Fabric8AutoConfiguration.or(kubernetesClientProperties.getPassword(), base.getPassword()))).withOauthToken(Fabric8AutoConfiguration.or(kubernetesClientProperties.getOauthToken(), base.getOauthToken()))).withCaCertFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.getCaCertFile(), base.getCaCertFile()))).withCaCertData(Fabric8AutoConfiguration.or(kubernetesClientProperties.getCaCertData(), base.getCaCertData()))).withClientKeyFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientKeyFile(), base.getClientKeyFile()))).withClientKeyData(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientKeyData(), base.getClientKeyData()))).withClientCertFile(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientCertFile(), base.getClientCertFile()))).withClientCertData(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientCertData(), base.getClientCertData()))).withClientKeyAlgo(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientKeyAlgo(), base.getClientKeyAlgo()))).withClientKeyPassphrase(Fabric8AutoConfiguration.or(kubernetesClientProperties.getClientKeyPassphrase(), base.getClientKeyPassphrase()))).withConnectionTimeout(Fabric8AutoConfiguration.orDurationInt(kubernetesClientProperties.getConnectionTimeout(), base.getConnectionTimeout()).intValue())).withRequestTimeout(Fabric8AutoConfiguration.orDurationInt(kubernetesClientProperties.getRequestTimeout(), base.getRequestTimeout()).intValue())).withRollingTimeout(Fabric8AutoConfiguration.orDurationLong(kubernetesClientProperties.getRollingTimeout(), base.getRollingTimeout()).longValue())).withTrustCerts(Fabric8AutoConfiguration.or(kubernetesClientProperties.isTrustCerts(), base.isTrustCerts()).booleanValue())).withHttpProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.getHttpProxy(), base.getHttpProxy()))).withHttpsProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.getHttpsProxy(), base.getHttpsProxy()))).withProxyUsername(Fabric8AutoConfiguration.or(kubernetesClientProperties.getProxyUsername(), base.getProxyUsername()))).withProxyPassword(Fabric8AutoConfiguration.or(kubernetesClientProperties.getProxyPassword(), base.getProxyPassword()))).withNoProxy(Fabric8AutoConfiguration.or(kubernetesClientProperties.getNoProxy(), base.getNoProxy()))).build();
        if (properties.getNamespace() == null || properties.getNamespace().isEmpty()) {
            LOG.warn((Object)"No namespace has been detected. Please specify KUBERNETES_NAMESPACE env var, or use a later kubernetes version (1.3 or later)");
        }
        return properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Config config) {
        return new DefaultKubernetesClient(config);
    }

    @Bean
    @ConditionalOnMissingBean
    public Fabric8PodUtils kubernetesPodUtils(KubernetesClient client) {
        return new Fabric8PodUtils(client);
    }
}

