/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discoveryserver;

import java.util.List;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnHttpDiscoveryCatalogWatcherEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnKubernetesCatalogEnabled;
import org.springframework.cloud.kubernetes.discoveryserver.HeartBeatListener;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@ConditionalOnKubernetesCatalogEnabled
@ConditionalOnHttpDiscoveryCatalogWatcherEnabled
class DiscoveryCatalogWatcherController {
    private final HeartBeatListener heartBeatListener;

    DiscoveryCatalogWatcherController(HeartBeatListener heartBeatListener) {
        this.heartBeatListener = heartBeatListener;
    }

    @GetMapping(value={"/state"})
    Mono<List<EndpointNameAndNamespace>> state() {
        return Mono.defer(() -> Mono.just(this.heartBeatListener.lastState().get()));
    }
}

