/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesAbstractReactiveDiscoveryClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

class KubernetesCacheableReactiveDiscoveryClient
extends KubernetesAbstractReactiveDiscoveryClient {
    KubernetesCacheableReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryProperties properties) {
        super(webClientBuilder, properties);
    }

    @Override
    @Cacheable(value={"k8s-reactive-discovery-services"})
    public Flux<String> getServices() {
        return super.getServices();
    }

    @Override
    @Cacheable(value={"k8s-reactive-discovery-instances"})
    public Flux<ServiceInstance> getInstances(String serviceId) {
        return super.getInstances(serviceId);
    }

    @Override
    public String description() {
        return "Reactive Cacheable Kubernetes Discovery Client";
    }
}

