/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.Service;
import org.springframework.cloud.kubernetes.discovery.DiscoveryServerUrlInvalidException;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

abstract class KubernetesAbstractBlockingDiscoveryClient
implements DiscoveryClient {
    private final RestTemplate rest;
    private final boolean emptyNamespaces;
    private final Set<String> namespaces;
    private final String discoveryServerUrl;

    KubernetesAbstractBlockingDiscoveryClient(RestTemplate rest, KubernetesDiscoveryProperties kubernetesDiscoveryProperties) {
        if (!StringUtils.hasText((String)kubernetesDiscoveryProperties.discoveryServerUrl())) {
            throw new DiscoveryServerUrlInvalidException();
        }
        this.rest = rest;
        this.emptyNamespaces = kubernetesDiscoveryProperties.namespaces().isEmpty();
        this.namespaces = kubernetesDiscoveryProperties.namespaces();
        this.discoveryServerUrl = kubernetesDiscoveryProperties.discoveryServerUrl();
    }

    public List<String> getServices() {
        Service[] services = (Service[])this.rest.getForEntity(this.discoveryServerUrl + "/apps", Service[].class, new Object[0]).getBody();
        if (services != null && services.length > 0) {
            return Arrays.stream(services).filter(this::matchNamespaces).map(Service::name).toList();
        }
        return List.of();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        DefaultKubernetesServiceInstance[] responseBody = (DefaultKubernetesServiceInstance[])this.rest.getForEntity(this.discoveryServerUrl + "/apps/" + serviceId, DefaultKubernetesServiceInstance[].class, new Object[0]).getBody();
        if (responseBody != null && responseBody.length > 0) {
            return Arrays.stream(responseBody).filter(this::matchNamespaces).collect(Collectors.toList());
        }
        return List.of();
    }

    public abstract String description();

    private boolean matchNamespaces(DefaultKubernetesServiceInstance kubernetesServiceInstance) {
        return this.emptyNamespaces || this.namespaces.contains(kubernetesServiceInstance.getNamespace());
    }

    private boolean matchNamespaces(Service service) {
        return service.serviceInstances().isEmpty() || service.serviceInstances().stream().anyMatch(this::matchNamespaces);
    }
}

