/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer;
import org.springframework.cloud.kubernetes.discovery.KubernetesCacheableDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryPodUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesBlockingDiscovery
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class, KubernetesDiscoveryProperties.class})
class KubernetesDiscoveryClientBlockingAutoConfiguration {
    KubernetesDiscoveryClientBlockingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    RestTemplateBuilder restTemplateBuilder() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]);
    }

    @Bean
    @ConditionalOnMissingBean
    PodUtils<?> kubernetesDiscoveryPodUtils() {
        return new KubernetesDiscoveryPodUtils();
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(PodUtils<?> podUtils, ApplicationEventPublisher applicationEventPublisher) {
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingDisabled
    KubernetesDiscoveryClient kubernetesDiscoveryClient(RestTemplateBuilder restTemplateBuilder, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryClient(restTemplateBuilder.build(), properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingEnabled
    KubernetesCacheableDiscoveryClient kubernetesCacheableDiscoveryClient(RestTemplateBuilder restTemplateBuilder, KubernetesDiscoveryProperties properties) {
        return new KubernetesCacheableDiscoveryClient(restTemplateBuilder.build(), properties);
    }
}

