/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.log.LogAccessor;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestTemplate;

final class KubernetesCatalogWatch
implements ApplicationEventPublisherAware {
    private static final ParameterizedTypeReference<List<EndpointNameAndNamespace>> TYPE = new ParameterizedTypeReference<List<EndpointNameAndNamespace>>(){};
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesCatalogWatch.class));
    private final AtomicReference<List<EndpointNameAndNamespace>> catalogState = new AtomicReference(List.of());
    private final RestTemplate restTemplate;
    private ApplicationEventPublisher publisher;

    KubernetesCatalogWatch(RestTemplateBuilder builder, KubernetesDiscoveryProperties properties) {
        this.restTemplate = builder.rootUri(properties.discoveryServerUrl()).build();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.kubernetes.discovery.catalogServicesWatchDelay:30000}")
    public void catalogServicesWatch() {
        try {
            List currentState = (List)this.restTemplate.exchange("/state", HttpMethod.GET, null, TYPE, new Object[0]).getBody();
            if (!this.catalogState.get().equals(currentState)) {
                LOG.debug(() -> "Received update from kubernetes discovery http client: " + String.valueOf(currentState));
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)currentState));
            }
            this.catalogState.set(currentState);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, () -> "Error watching Kubernetes Services");
        }
    }
}

