/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnSpringCloudKubernetesBlockingDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryPodUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesBlockingDiscovery
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class, KubernetesDiscoveryProperties.class})
class KubernetesDiscoveryClientBlockingAutoConfiguration {
    KubernetesDiscoveryClientBlockingAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    RestTemplate restTemplate() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
    }

    @Bean
    @ConditionalOnMissingBean
    KubernetesDiscoveryClient kubernetesDiscoveryClient(RestTemplate restTemplate, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryClient(restTemplate, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    PodUtils<?> kubernetesDiscoveryPodUtils() {
        return new KubernetesDiscoveryPodUtils();
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(PodUtils<?> podUtils, ApplicationEventPublisher applicationEventPublisher) {
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }
}

