/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientProperties;
import org.springframework.util.ClassUtils;

class ConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    ConfigServerBootstrapper() {
    }

    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null)) {
            return;
        }
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, KubernetesFunction::create);
    }

    static final class KubernetesFunction
    implements ConfigServerInstanceProvider.Function {
        private final BootstrapContext context;

        private KubernetesFunction(BootstrapContext context) {
            this.context = context;
        }

        static KubernetesFunction create(BootstrapContext context) {
            return new KubernetesFunction(context);
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || bindHandler == null || !KubernetesConfigServerBootstrapper.getDiscoveryEnabled((Binder)binder, (BindHandler)bindHandler).booleanValue()) {
                return Collections.emptyList();
            }
            KubernetesDiscoveryProperties discoveryProperties = KubernetesConfigServerBootstrapper.createKubernetesDiscoveryProperties((Binder)binder, (BindHandler)bindHandler);
            KubernetesClientProperties clientProperties = KubernetesConfigServerBootstrapper.createKubernetesClientProperties((Binder)binder, (BindHandler)bindHandler);
            return this.getInstanceProvider(discoveryProperties, clientProperties, this.context, binder, bindHandler, log).getInstances(serviceId);
        }

        private KubernetesConfigServerInstanceProvider getInstanceProvider(KubernetesDiscoveryProperties discoveryProperties, KubernetesClientProperties clientProperties, BootstrapContext context, Binder binder, BindHandler bindHandler, Log log) {
            KubernetesDiscoveryClientProperties kubernetesDiscoveryClientProperties = (KubernetesDiscoveryClientProperties)binder.bind("spring.cloud.kubernetes.discovery", Bindable.of(KubernetesDiscoveryClientProperties.class), bindHandler).orElseGet(KubernetesDiscoveryClientProperties::new);
            KubernetesDiscoveryClientAutoConfiguration.Servlet autoConfiguration = new KubernetesDiscoveryClientAutoConfiguration.Servlet();
            DiscoveryClient discoveryClient = autoConfiguration.kubernetesDiscoveryClient(autoConfiguration.restTemplate(), kubernetesDiscoveryClientProperties);
            return arg_0 -> ((DiscoveryClient)discoveryClient).getInstances(arg_0);
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }
    }
}

