/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.reactive.ReactiveDiscoveryClientHealthIndicator;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.discovery.KubernetesDiscoveryClientProperties;
import org.springframework.cloud.kubernetes.discovery.KubernetesReactiveDiscoveryClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled", "spring.cloud.kubernetes.discovery.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DiscoveryClientHealthIndicatorProperties.class, KubernetesDiscoveryClientProperties.class})
public class KubernetesDiscoveryClientAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    public static class Reactive {
        @Bean
        @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
        @ConditionalOnMissingBean(value={WebClient.Builder.class})
        public WebClient.Builder webClientBuilder() {
            return WebClient.builder();
        }

        @Bean
        @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
        public ReactiveDiscoveryClient kubernetesReactiveDiscoveryClient(WebClient.Builder webClientBuilder, KubernetesDiscoveryClientProperties properties) {
            return new KubernetesReactiveDiscoveryClient(webClientBuilder, properties);
        }

        @Bean
        @ConditionalOnClass(name={"org.springframework.boot.actuate.health.ReactiveHealthIndicator"})
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public ReactiveDiscoveryClientHealthIndicator kubernetesReactiveDiscoveryClientHealthIndicator(KubernetesReactiveDiscoveryClient client, DiscoveryClientHealthIndicatorProperties properties, ApplicationContext applicationContext) {
            ReactiveDiscoveryClientHealthIndicator healthIndicator = new ReactiveDiscoveryClientHealthIndicator((ReactiveDiscoveryClient)client, properties);
            InstanceRegisteredEvent event = new InstanceRegisteredEvent((Object)applicationContext.getId(), null);
            healthIndicator.onApplicationEvent(event);
            return healthIndicator;
        }
    }

    @Configuration(proxyBeanMethods=false)
    public static class Servlet {
        @Bean
        @ConditionalOnMissingClass(value={"org.springframework.web.reactive.function.client.WebClient"})
        public RestTemplate restTemplate() {
            return new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
        }

        @Bean
        @ConditionalOnMissingClass(value={"org.springframework.web.reactive.function.client.WebClient"})
        public DiscoveryClient kubernetesDiscoveryClient(RestTemplate restTemplate, KubernetesDiscoveryClientProperties properties) {
            return new KubernetesDiscoveryClient(restTemplate, properties);
        }

        @Bean
        @ConditionalOnClass(value={HealthIndicator.class})
        @ConditionalOnDiscoveryHealthIndicatorEnabled
        public InitializingBean indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, ApplicationContext applicationContext) {
            return () -> applicationEventPublisher.publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)applicationContext.getId(), null));
        }
    }
}

