/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class KubernetesServiceInstance
implements ServiceInstance {
    public static final String NAMESPACE_METADATA_KEY = "k8s_namespace";
    private static final String HTTP_PREFIX = "http";
    private static final String HTTPS_PREFIX = "https";
    private static final String DSL = "//";
    private static final String COLON = ":";
    private final String instanceId;
    private final String serviceId;
    private final String host;
    private final int port;
    private final URI uri;
    private final Boolean secure;
    private final Map<String, String> metadata;

    public KubernetesServiceInstance(String instanceId, String serviceId, String host, int port, Map<String, String> metadata, Boolean secure) {
        this.instanceId = instanceId;
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
        this.metadata = metadata;
        this.secure = secure;
        this.uri = this.createUri(secure != false ? HTTPS_PREFIX : HTTP_PREFIX, host, port);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.isSecure() ? HTTPS_PREFIX : HTTP_PREFIX;
    }

    private URI createUri(String scheme, String host, int port) {
        StringBuilder sb = new StringBuilder();
        sb.append(scheme).append(COLON).append(DSL).append(host).append(COLON).append(port);
        return URI.create(sb.toString());
    }

    public String getNamespace() {
        return this.metadata != null ? this.metadata.get(NAMESPACE_METADATA_KEY) : null;
    }
}

