/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Scheduled;

public class KubernetesCatalogWatch
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesCatalogWatch.class);
    private final KubernetesClient kubernetesClient;
    private final AtomicReference<List<String>> catalogEndpointsState = new AtomicReference();
    private ApplicationEventPublisher publisher;

    public KubernetesCatalogWatch(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.kubernetes.discovery.catalogServicesWatchDelay:30000}")
    public void catalogServicesWatch() {
        try {
            List<String> previousState = this.catalogEndpointsState.get();
            List endpoints = ((EndpointsList)this.kubernetesClient.endpoints().list()).getItems();
            List endpointsPodNames = endpoints.stream().map(Endpoints::getSubsets).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointSubset::getAddresses).filter(Objects::nonNull).flatMap(Collection::stream).map(EndpointAddress::getTargetRef).filter(Objects::nonNull).map(ObjectReference::getName).sorted(String::compareTo).collect(Collectors.toList());
            this.catalogEndpointsState.set(endpointsPodNames);
            if (!endpointsPodNames.equals(previousState)) {
                logger.trace("Received endpoints update from kubernetesClient: {}", endpointsPodNames);
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, endpointsPodNames));
            }
        }
        catch (Exception e) {
            logger.error("Error watching Kubernetes Services", (Throwable)e);
        }
    }
}

