/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.kubernetes.client.common.KubernetesObject;
import org.springframework.cloud.bus.event.PathDestinationFactory;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.kubernetes.configuration.watcher.RefreshTrigger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import reactor.core.publisher.Mono;

final class BusRefreshTrigger
implements RefreshTrigger {
    private final ApplicationEventPublisher applicationEventPublisher;
    private final String busId;

    BusRefreshTrigger(ApplicationEventPublisher applicationEventPublisher, String busId) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.busId = busId;
    }

    public Mono<Void> triggerRefresh(KubernetesObject configMap, String appName) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRemoteApplicationEvent((Object)configMap, this.busId, new PathDestinationFactory().getDestination(appName)));
        return Mono.empty();
    }
}

