/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpBasedConfigMapWatchChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.HttpBasedSecretsWatchChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.SecretsWatcherChangeDetector;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.fabric8.discovery.reactive.KubernetesReactiveDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ConfigurationWatcherConfigurationProperties.class})
public class ConfigurationWatcherAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(WebClient.Builder webClientBuilder) {
        return webClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={ConfigMapWatcherChangeDetector.class})
    @ConditionalOnBean(value={Fabric8ConfigMapPropertySourceLocator.class})
    public ConfigMapWatcherChangeDetector httpBasedConfigMapWatchChangeDetector(AbstractEnvironment environment, KubernetesClient kubernetesClient, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadFactory, WebClient webClient, KubernetesReactiveDiscoveryClient kubernetesReactiveDiscoveryClient) {
        return new HttpBasedConfigMapWatchChangeDetector(environment, properties, kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator, k8SConfigurationProperties, threadFactory, webClient, kubernetesReactiveDiscoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecretsWatcherChangeDetector.class})
    @ConditionalOnBean(value={Fabric8SecretsPropertySourceLocator.class})
    public SecretsWatcherChangeDetector httpBasedSecretsWatchChangeDetector(AbstractEnvironment environment, KubernetesClient kubernetesClient, Fabric8SecretsPropertySourceLocator fabric8SecretsPropertySourceLocator, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadFactory, WebClient webClient, KubernetesReactiveDiscoveryClient kubernetesReactiveDiscoveryClient) {
        return new HttpBasedSecretsWatchChangeDetector(environment, properties, kubernetesClient, strategy, fabric8SecretsPropertySourceLocator, k8SConfigurationProperties, threadFactory, webClient, kubernetesReactiveDiscoveryClient);
    }
}

