/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.event.RefreshRemoteApplicationEvent;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigMapWatcherChangeDetector;
import org.springframework.cloud.kubernetes.configuration.watcher.ConfigurationWatcherConfigurationProperties;
import org.springframework.cloud.kubernetes.fabric8.config.Fabric8ConfigMapPropertySourceLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import reactor.core.publisher.Mono;

public class BusEventBasedConfigMapWatcherChangeDetector
extends ConfigMapWatcherChangeDetector
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;
    private BusProperties busProperties;

    public BusEventBasedConfigMapWatcherChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy, Fabric8ConfigMapPropertySourceLocator fabric8ConfigMapPropertySourceLocator, BusProperties busProperties, ConfigurationWatcherConfigurationProperties k8SConfigurationProperties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        super(environment, properties, kubernetesClient, strategy, fabric8ConfigMapPropertySourceLocator, k8SConfigurationProperties, threadPoolTaskExecutor);
        this.busProperties = busProperties;
    }

    protected Mono<Void> triggerRefresh(ConfigMap configMap) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRemoteApplicationEvent((Object)configMap, this.busProperties.getId(), configMap.getMetadata().getName()));
        return Mono.empty();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

