/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.configuration.watcher;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="spring.cloud.kubernetes.configuration.watcher")
public class ConfigurationWatcherConfigurationProperties {
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration refreshDelay = Duration.ofMillis(120000L);
    private int threadPoolSize = 1;
    private String configLabel = "spring.cloud.kubernetes.config";
    private String secretLabel = "spring.cloud.kubernetes.secret";
    private String actuatorPath = "/actuator";
    private Integer actuatorPort = -1;

    public String getActuatorPath() {
        return this.actuatorPath;
    }

    public void setActuatorPath(String actuatorPath) {
        String normalizedPath = actuatorPath;
        if (!normalizedPath.startsWith("/")) {
            normalizedPath = "/" + normalizedPath;
        }
        if (normalizedPath.endsWith("/")) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        this.actuatorPath = normalizedPath;
    }

    public Integer getActuatorPort() {
        return this.actuatorPort;
    }

    public void setActuatorPort(Integer actuatorPort) {
        this.actuatorPort = actuatorPort;
    }

    public String getSecretLabel() {
        return this.secretLabel;
    }

    public void setSecretLabel(String secretLabel) {
        this.secretLabel = secretLabel;
    }

    public String getConfigLabel() {
        return this.configLabel;
    }

    public void setConfigLabel(String configLabel) {
        this.configLabel = configLabel;
    }

    public Duration getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(Duration refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

