/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.config.SecretsPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=1)
public class SecretsPropertySourceLocator
implements PropertySourceLocator {
    private final KubernetesClient client;
    private final SecretsConfigProperties properties;

    public SecretsPropertySourceLocator(KubernetesClient client, SecretsConfigProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public MapPropertySource locate(Environment environment) {
        return environment instanceof ConfigurableEnvironment ? new SecretsPropertySource(this.client, environment, this.properties) : null;
    }
}

