/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;

final class ProfileActivationAwareYamlPropertiesFactoryBean {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ProfileActivationAwareYamlPropertiesFactoryBean.class));
    private List<YamlProcessor.DocumentMatcher> documentMatchers = Collections.emptyList();

    ProfileActivationAwareYamlPropertiesFactoryBean() {
    }

    Map<String, Object> createProperties(String source) {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        Yaml yaml = new Yaml();
        ByteArrayResource resource = new ByteArrayResource(source.getBytes(StandardCharsets.UTF_8));
        try (UnicodeReader reader = new UnicodeReader(resource.getInputStream());){
            Iterable iterable = yaml.loadAll((Reader)reader);
            ArrayList<LinkedHashMap<String, Object>> allYamlDocuments = new ArrayList<LinkedHashMap<String, Object>>();
            for (Object singleYamlDocument : iterable) {
                if (singleYamlDocument == null) continue;
                LinkedHashMap<String, Object> flattenedMap = new LinkedHashMap<String, Object>();
                Map<String, Object> originalSource = ProfileActivationAwareYamlPropertiesFactoryBean.asMap(singleYamlDocument);
                ProfileActivationAwareYamlPropertiesFactoryBean.buildFlattenedMapWithoutComplexObjects(flattenedMap, originalSource, null);
                allYamlDocuments.add(flattenedMap);
            }
            List<LinkedHashMap<String, Object>> yamlDocumentsMatchedAgainstDocumentMatchers = this.filterBasedOnDocumentMatchers(allYamlDocuments);
            Map<Boolean, List<LinkedHashMap>> partitioned = yamlDocumentsMatchedAgainstDocumentMatchers.stream().collect(Collectors.partitioningBy(x -> !x.containsKey("spring.config.activate.on-profile") && !x.containsKey("spring.profiles")));
            LOG.debug(() -> "non-profile source : " + ((List)partitioned.get(Boolean.TRUE)).toString());
            LOG.debug(() -> "profile source : " + String.valueOf(partitioned.get(Boolean.FALSE)));
            LinkedHashMap<String, Object> flattenedWithoutComplexObjects = new LinkedHashMap<String, Object>();
            partitioned.get(Boolean.TRUE).forEach(flattenedWithoutComplexObjects::putAll);
            partitioned.get(Boolean.FALSE).forEach(flattenedWithoutComplexObjects::putAll);
            ProfileActivationAwareYamlPropertiesFactoryBean.buildFlattenedMap(finalMap, flattenedWithoutComplexObjects, null);
            LOG.debug(() -> "final source : " + String.valueOf(finalMap));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return finalMap;
    }

    void setDocumentMatchers(YamlProcessor.DocumentMatcher ... matchers) {
        this.documentMatchers = List.of(matchers);
    }

    private List<LinkedHashMap<String, Object>> filterBasedOnDocumentMatchers(List<LinkedHashMap<String, Object>> allDocuments) {
        return allDocuments.stream().filter(x -> {
            Properties properties = CollectionFactory.createStringAdaptingProperties();
            properties.putAll((Map<?, ?>)x);
            YamlProcessor.MatchStatus matchStatus = YamlProcessor.MatchStatus.ABSTAIN;
            for (YamlProcessor.DocumentMatcher matcher : this.documentMatchers) {
                YamlProcessor.MatchStatus match = matcher.matches(properties);
                matchStatus = YamlProcessor.MatchStatus.getMostSpecific((YamlProcessor.MatchStatus)match, (YamlProcessor.MatchStatus)matchStatus);
                if (match == YamlProcessor.MatchStatus.FOUND) {
                    LOG.debug(() -> "Matched document with document matcher: " + String.valueOf(properties));
                    return true;
                }
                if (matchStatus != YamlProcessor.MatchStatus.ABSTAIN) continue;
                LOG.debug(() -> "Matched document with default matcher: " + String.valueOf(properties));
                return true;
            }
            return false;
        }).toList();
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, @Nullable String path) {
        source.forEach((key, value) -> {
            if (StringUtils.hasText((String)path)) {
                key = ((String)key).startsWith("[") ? path + (String)key : path + "." + (String)key;
            }
            if (value instanceof String) {
                result.put((String)key, value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                ProfileActivationAwareYamlPropertiesFactoryBean.buildFlattenedMap(result, map, (String)key);
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    result.put((String)key, "");
                } else {
                    int count = 0;
                    for (Object object : collection) {
                        ProfileActivationAwareYamlPropertiesFactoryBean.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), (String)key);
                    }
                }
            } else {
                result.put((String)key, value != null ? value : "");
            }
        });
    }

    private static void buildFlattenedMapWithoutComplexObjects(Map<String, Object> result, Map<String, Object> source, @Nullable String path) {
        source.forEach((key, value) -> {
            if (StringUtils.hasText((String)path)) {
                key = ((String)key).startsWith("[") ? path + (String)key : path + "." + (String)key;
            }
            if (value instanceof String) {
                result.put((String)key, value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                ProfileActivationAwareYamlPropertiesFactoryBean.buildFlattenedMapWithoutComplexObjects(result, map, (String)key);
            } else if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (collection.isEmpty()) {
                    result.put((String)key, "");
                } else {
                    result.put((String)key, collection);
                }
            } else {
                result.put((String)key, value != null ? value : "");
            }
        });
    }

    private static Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (object instanceof Map) {
            Map map = (Map)object;
            map.forEach((key, value) -> {
                if (value instanceof Map) {
                    value = ProfileActivationAwareYamlPropertiesFactoryBean.asMap(value);
                }
                if (key instanceof CharSequence) {
                    result.put(key.toString(), value);
                } else {
                    result.put("[" + key.toString() + "]", value);
                }
            });
        }
        return result;
    }
}

