/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

final class SourceDataFlattener {
    private SourceDataFlattener() {
    }

    static Map<String, Object> defaultFlattenedSourceData(LinkedHashSet<String> names, Map<String, Object> rawData) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        names.forEach(name -> {
            Map singleDataEntry = rawData.getOrDefault(name, Map.of());
            flattenedData.putAll(singleDataEntry);
        });
        return flattenedData;
    }

    static Map<String, Object> prefixFlattenedSourceData(LinkedHashSet<String> names, Map<String, Object> rawData, String prefix) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        names.forEach(name -> {
            Map<String, Object> singleDataEntry = rawData.getOrDefault(name, Map.of());
            singleDataEntry.forEach((key, value) -> flattenedData.put(prefix + "." + key, value));
        });
        return flattenedData;
    }

    static Map<String, Object> nameFlattenedSourceData(LinkedHashSet<String> names, Map<String, Object> rawData) {
        HashMap<String, Object> flattenedData = new HashMap<String, Object>();
        names.forEach(name -> {
            Map<String, Object> singleDataEntry = rawData.getOrDefault(name, Map.of());
            singleDataEntry.forEach((key, value) -> flattenedData.put(name + "." + key, value));
        });
        return flattenedData;
    }
}

