/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.InstanceIdHostPodName;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.PodLabelsAndAnnotations;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.core.log.LogAccessor;

public final class DiscoveryClientUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(DiscoveryClientUtils.class));

    private DiscoveryClientUtils() {
        throw new AssertionError((Object)"no instance provided");
    }

    public static Map<String, String> serviceInstanceMetadata(Map<String, Integer> portsData, ServiceMetadata serviceMetadata, KubernetesDiscoveryProperties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        KubernetesDiscoveryProperties.Metadata metadataProps = properties.metadata();
        if (metadataProps.addLabels()) {
            Map<String, String> labelMetadata = ConfigUtils.keysWithPrefix(serviceMetadata.labels(), metadataProps.labelsPrefix());
            LOG.debug(() -> "Adding labels metadata: " + labelMetadata + " for serviceId: " + serviceMetadata.name());
            result.putAll(labelMetadata);
        }
        if (metadataProps.addAnnotations()) {
            Map<String, String> annotationMetadata = ConfigUtils.keysWithPrefix(serviceMetadata.annotations(), metadataProps.annotationsPrefix());
            LOG.debug(() -> "Adding annotations metadata: " + annotationMetadata + " for serviceId: " + serviceMetadata.name());
            result.putAll(annotationMetadata);
        }
        if (metadataProps.addPorts()) {
            Map<String, String> portsDataValueAsString = portsData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> Integer.toString((Integer)en.getValue())));
            Map<String, String> portMetadata = ConfigUtils.keysWithPrefix(portsDataValueAsString, properties.metadata().portsPrefix());
            if (!portMetadata.isEmpty()) {
                LOG.debug(() -> "Adding port metadata: " + portMetadata + " for serviceId : " + serviceMetadata.name());
            }
            result.putAll(portMetadata);
        }
        result.put("k8s_namespace", serviceMetadata.namespace());
        result.put("type", serviceMetadata.type());
        return result;
    }

    public static ServicePortNameAndNumber endpointsPort(Map<String, Integer> existingPorts, ServiceMetadata serviceMetadata, KubernetesDiscoveryProperties properties) {
        if (existingPorts.isEmpty()) {
            LOG.debug(() -> "no ports found for service : " + serviceMetadata.name() + ", will return zero");
            return new ServicePortNameAndNumber(0, "http");
        }
        if (existingPorts.size() == 1) {
            Map.Entry<String, Integer> single = existingPorts.entrySet().iterator().next();
            LOG.debug(() -> "endpoint ports has a single entry, using port : " + single.getValue());
            return new ServicePortNameAndNumber(single.getValue(), single.getKey());
        }
        String primaryPortName = DiscoveryClientUtils.primaryPortName(properties, serviceMetadata.labels(), serviceMetadata.name());
        Optional<ServicePortNameAndNumber> portData = DiscoveryClientUtils.fromMap(existingPorts, primaryPortName, "found primary-port-name (with value: '" + primaryPortName + "') via properties or service labels to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        portData = DiscoveryClientUtils.fromMap(existingPorts, "https", "found primary-port-name via 'https' to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        portData = DiscoveryClientUtils.fromMap(existingPorts, "http", "found primary-port-name via 'http' to match port");
        if (portData.isPresent()) {
            return portData.get();
        }
        DiscoveryClientUtils.logWarnings();
        Map.Entry<String, Integer> first = existingPorts.entrySet().iterator().next();
        return new ServicePortNameAndNumber(first.getValue(), first.getKey());
    }

    public static ServiceInstance serviceInstance(@Nullable ServicePortSecureResolver servicePortSecureResolver, ServiceMetadata serviceMetadata, Supplier<InstanceIdHostPodName> instanceIdAndHost, Function<String, PodLabelsAndAnnotations> podLabelsAndMetadata, ServicePortNameAndNumber portData, Map<String, String> serviceInstanceMetadata, KubernetesDiscoveryProperties properties) {
        InstanceIdHostPodName data = instanceIdAndHost.get();
        boolean secured = servicePortSecureResolver == null ? false : servicePortSecureResolver.resolve(new ServicePortSecureResolver.Input(portData, serviceMetadata.name(), serviceMetadata.labels(), serviceMetadata.annotations()));
        Map<String, Map<String, String>> podMetadata = DiscoveryClientUtils.podMetadata(data.podName(), serviceInstanceMetadata, properties, podLabelsAndMetadata);
        return new DefaultKubernetesServiceInstance(data.instanceId(), serviceMetadata.name(), data.host(), portData.portNumber(), serviceInstanceMetadata, secured, serviceMetadata.namespace(), null, podMetadata);
    }

    static String primaryPortName(KubernetesDiscoveryProperties properties, Map<String, String> serviceLabels, String serviceId) {
        String primaryPortNameFromProperties = properties.primaryPortName();
        String primaryPortName = Optional.ofNullable((String)Optional.ofNullable(serviceLabels).orElse(Map.of()).get("primary-port-name")).orElse(primaryPortNameFromProperties);
        if (primaryPortName == null) {
            LOG.debug(() -> "did not find a primary-port-name in neither properties nor service labels for service with ID : " + serviceId);
            return null;
        }
        LOG.debug(() -> "will use primaryPortName : " + primaryPortName + " for service with ID = " + serviceId);
        return primaryPortName;
    }

    static Map<String, Map<String, String>> podMetadata(String podName, Map<String, String> serviceMetadata, KubernetesDiscoveryProperties properties, Function<String, PodLabelsAndAnnotations> podLabelsAndMetadata) {
        if (!"ExternalName".equals(serviceMetadata.get("type")) && (properties.metadata().addPodLabels() || properties.metadata().addPodAnnotations())) {
            LOG.debug(() -> "Pod labels/annotations were requested");
            if (podName != null) {
                LOG.debug(() -> "getting labels/annotation for pod: " + podName);
                PodLabelsAndAnnotations both = podLabelsAndMetadata.apply(podName);
                HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
                if (properties.metadata().addPodLabels() && !both.labels().isEmpty()) {
                    result.put("labels", both.labels());
                }
                if (properties.metadata().addPodAnnotations() && !both.annotations().isEmpty()) {
                    result.put("annotations", both.annotations());
                }
                LOG.debug(() -> "adding podMetadata : " + result + " from pod : " + podName);
                return result;
            }
        }
        return Map.of();
    }

    private static Optional<ServicePortNameAndNumber> fromMap(Map<String, Integer> existingPorts, String key, String message) {
        Integer fromPrimaryPortName = existingPorts.get(key);
        if (fromPrimaryPortName == null) {
            LOG.debug(() -> "not " + message);
            return Optional.empty();
        }
        LOG.debug(() -> message + " : " + fromPrimaryPortName);
        return Optional.of(new ServicePortNameAndNumber(fromPrimaryPortName, key));
    }

    private static void logWarnings() {
        LOG.warn(() -> "Make sure that either the primary-port-name label has been added to the service,\nor spring.cloud.kubernetes.discovery.primary-port-name has been configured.\nAlternatively name the primary port 'https' or 'http'\nAn incorrect configuration may result in non-deterministic behaviour.");
    }
}

