/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.discovery;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;

public class KubernetesServiceInstance
implements ServiceInstance {
    public static final String NAMESPACE_METADATA_KEY = "k8s_namespace";
    private static final String HTTP_PREFIX = "http";
    private static final String HTTPS_PREFIX = "https";
    private static final String DSL = "//";
    private static final String COLON = ":";
    private final String instanceId;
    private final String serviceId;
    private final String host;
    private final int port;
    private final URI uri;
    private final Boolean secure;
    private final Map<String, String> metadata;

    public KubernetesServiceInstance(String instanceId, String serviceId, String host, int port, Map<String, String> metadata, Boolean secure) {
        this.instanceId = instanceId;
        this.serviceId = serviceId;
        this.host = host;
        this.port = port;
        this.metadata = metadata;
        this.secure = secure;
        this.uri = this.createUri(secure != false ? HTTPS_PREFIX : HTTP_PREFIX, host, port);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.isSecure() ? HTTPS_PREFIX : HTTP_PREFIX;
    }

    private URI createUri(String scheme, String host, int port) {
        return URI.create(scheme + COLON + DSL + host + COLON + port);
    }

    public String getNamespace() {
        return this.metadata != null ? this.metadata.get(NAMESPACE_METADATA_KEY) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesServiceInstance that = (KubernetesServiceInstance)o;
        return this.port == that.port && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.host, that.host) && Objects.equals(this.uri, that.uri) && Objects.equals(this.secure, that.secure) && Objects.equals(this.metadata, that.metadata);
    }

    public String toString() {
        return "KubernetesServiceInstance{instanceId='" + this.instanceId + '\'' + ", serviceId='" + this.serviceId + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", uri=" + this.uri + ", secure=" + this.secure + ", metadata=" + this.metadata + '}';
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.serviceId, this.host, this.port, this.uri, this.secure, this.metadata);
    }
}

