/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.V1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient,
InitializingBean {
    private static final Log log = LogFactory.getLog(KubernetesInformerDiscoveryClient.class);
    private static final String PRIMARY_PORT_NAME_LABEL_KEY = "primary-port-name";
    private static final String HTTPS_PORT_NAME = "https";
    private static final String HTTP_PORT_NAME = "http";
    private final SharedInformerFactory sharedInformerFactory;
    private final Lister<V1Service> serviceLister;
    private final Supplier<Boolean> informersReadyFunc;
    private final Lister<V1Endpoints> endpointsLister;
    private final KubernetesDiscoveryProperties properties;
    private final String namespace;

    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.namespace = namespace;
        this.sharedInformerFactory = sharedInformerFactory;
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
    }

    public String description() {
        return "Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        V1Endpoints ep;
        V1Service service;
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        if (!StringUtils.hasText((String)this.namespace) && !this.properties.isAllNamespaces()) {
            log.warn((Object)"Namespace is null or empty, this may cause issues looking up services");
        }
        V1Service v1Service = service = this.properties.isAllNamespaces() ? (V1Service)this.serviceLister.list().stream().filter(svc -> serviceId.equals(svc.getMetadata().getName())).findFirst().orElse(null) : (V1Service)this.serviceLister.namespace(this.namespace).get(serviceId);
        if (service == null || !this.matchServiceLabels(service)) {
            return new ArrayList<ServiceInstance>();
        }
        HashMap svcMetadata = new HashMap();
        if (this.properties.getMetadata() != null) {
            if (this.properties.getMetadata().isAddLabels() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
                String labelPrefix = this.properties.getMetadata().getLabelsPrefix() != null ? this.properties.getMetadata().getLabelsPrefix() : "";
                service.getMetadata().getLabels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(labelPrefix)).forEach(e -> {
                    String cfr_ignored_0 = (String)svcMetadata.put(e.getKey(), e.getValue());
                });
            }
            if (this.properties.getMetadata().isAddAnnotations() && service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
                String annotationPrefix = this.properties.getMetadata().getAnnotationsPrefix() != null ? this.properties.getMetadata().getAnnotationsPrefix() : "";
                service.getMetadata().getAnnotations().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(annotationPrefix)).forEach(e -> {
                    String cfr_ignored_0 = (String)svcMetadata.put(e.getKey(), e.getValue());
                });
            }
        }
        if ((ep = (V1Endpoints)this.endpointsLister.namespace(service.getMetadata().getNamespace()).get(service.getMetadata().getName())) == null || ep.getSubsets() == null) {
            return new ArrayList<ServiceInstance>();
        }
        Optional<String> discoveredPrimaryPortName = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            discoveredPrimaryPortName = Optional.ofNullable(service.getMetadata().getLabels().get(PRIMARY_PORT_NAME_LABEL_KEY));
        }
        String primaryPortName = discoveredPrimaryPortName.orElse(this.properties.getPrimaryPortName());
        return ep.getSubsets().stream().filter(subset -> subset.getPorts() != null && subset.getPorts().size() > 0).flatMap(subset -> {
            ArrayList addresses;
            HashMap metadata = new HashMap(svcMetadata);
            List endpointPorts = subset.getPorts();
            if (this.properties.getMetadata() != null && this.properties.getMetadata().isAddPorts()) {
                endpointPorts.forEach(p -> metadata.put(p.getName(), Integer.toString(p.getPort())));
            }
            if ((addresses = subset.getAddresses()) == null) {
                addresses = new ArrayList();
            }
            if (this.properties.isIncludeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)subset.getNotReadyAddresses())) {
                addresses.addAll(subset.getNotReadyAddresses());
            }
            int port = this.findEndpointPort(endpointPorts, primaryPortName, serviceId);
            return addresses.stream().map(addr -> new KubernetesServiceInstance(addr.getTargetRef() != null ? addr.getTargetRef().getUid() : "", serviceId, addr.getIp(), port, metadata, Boolean.valueOf(false)));
        }).collect(Collectors.toList());
    }

    private int findEndpointPort(List<V1EndpointPort> endpointPorts, String primaryPortName, String serviceId) {
        if (endpointPorts.size() == 1) {
            return endpointPorts.get(0).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(V1EndpointPort::getName, V1EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault(HTTPS_PORT_NAME, ports.getOrDefault(HTTP_PORT_NAME, -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                log.warn((Object)("Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'."));
            } else {
                log.warn((Object)("Could not find a port named 'https' or 'http' for service '" + serviceId + "'."));
            }
            log.warn((Object)"Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            log.warn((Object)"Alternatively name the primary port 'https' or 'http'");
            log.warn((Object)"An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = endpointPorts.get(0).getPort();
        }
        return discoveredPort;
    }

    public List<String> getServices() {
        List services = this.properties.isAllNamespaces() ? this.serviceLister.list() : this.serviceLister.namespace(this.namespace).list();
        return services.stream().filter(this::matchServiceLabels).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.sharedInformerFactory.startAllRegisteredInformers();
        if (!Wait.poll((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(this.properties.getCacheLoadingTimeoutSeconds()), () -> {
            log.info((Object)"Waiting for the cache of informers to be fully loaded..");
            return this.informersReadyFunc.get();
        })) {
            if (this.properties.isWaitCacheReady()) {
                throw new IllegalStateException("Timeout waiting for informers cache to be ready, is the kubernetes service up?");
            }
            log.warn((Object)"Timeout waiting for informers cache to be ready, ignoring the failure because waitForInformerCacheReady property is false");
        }
        log.info((Object)("Cache fully loaded (total " + this.serviceLister.list().size() + " services) , discovery client is now available"));
    }

    private boolean matchServiceLabels(V1Service service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Kubernetes Service Label Properties:");
            if (this.properties.getServiceLabels() != null) {
                this.properties.getServiceLabels().forEach((key, value) -> log.debug((Object)(key + ":" + value)));
            }
            log.debug((Object)("Service " + service.getMetadata().getName() + " labels:"));
            if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
                service.getMetadata().getLabels().forEach((key, value) -> log.debug((Object)(key + ":" + value)));
            }
        }
        if (service.getMetadata() == null) {
            return false;
        }
        if (this.properties.getServiceLabels() == null || this.properties.getServiceLabels().isEmpty()) {
            return true;
        }
        return this.properties.getServiceLabels().keySet().stream().allMatch(k -> service.getMetadata().getLabels() != null && service.getMetadata().getLabels().containsKey(k) && ((String)service.getMetadata().getLabels().get(k)).equals(this.properties.getServiceLabels().get(k)));
    }
}

