/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;

public final class KubernetesClientSourcesBatchRead {
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> SECRETS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CONFIGMAPS_CACHE = new ConcurrentHashMap();

    private KubernetesClientSourcesBatchRead() {
    }

    public static void discardSecrets() {
        SECRETS_CACHE.clear();
    }

    public static void discardConfigMaps() {
        CONFIGMAPS_CACHE.clear();
    }

    static List<StrippedSourceContainer> strippedConfigMaps(CoreV1Api coreV1Api, String namespace) {
        return CONFIGMAPS_CACHE.computeIfAbsent(namespace, x -> {
            try {
                return KubernetesClientConfigUtils.stripConfigMaps(coreV1Api.listNamespacedConfigMap(namespace).execute().getItems());
            }
            catch (ApiException apiException) {
                throw new RuntimeException(apiException.getResponseBody(), apiException);
            }
        });
    }

    static List<StrippedSourceContainer> strippedSecrets(CoreV1Api coreV1Api, String namespace) {
        return SECRETS_CACHE.computeIfAbsent(namespace, x -> {
            try {
                return KubernetesClientConfigUtils.stripSecrets(coreV1Api.listNamespacedSecret(namespace).execute().getItems());
            }
            catch (ApiException apiException) {
                throw new RuntimeException(apiException.getResponseBody(), apiException);
            }
        });
    }
}

