/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config.reload;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.reload.KubernetesClientEventBasedConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.client.config.reload.KubernetesClientEventBasedSecretsChangeDetector;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingConfigMapChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.PollingSecretsChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.ConditionalOnConfigMapsReloadEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.ConditionalOnKubernetesReloadEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.ConditionalOnSecretsReloadEnabled;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.EventReloadDetectionMode;
import org.springframework.cloud.kubernetes.commons.config.reload.condition.PollingReloadDetectionMode;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.TaskScheduler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCloudPlatform(value=CloudPlatform.KUBERNETES)
@ConditionalOnKubernetesReloadEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class, RestartEndpoint.class, ContextRefresher.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class, ConfigReloadPropertiesAutoConfiguration.class})
@Import(value={ConfigReloadAutoConfiguration.class})
public class KubernetesClientConfigReloadAutoConfiguration {
    @Bean
    @ConditionalOnConfigMapsReloadEnabled
    @ConditionalOnBean(value={KubernetesClientConfigMapPropertySourceLocator.class})
    @Conditional(value={PollingReloadDetectionMode.class})
    public ConfigurationChangeDetector configMapPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator, AbstractEnvironment environment, TaskSchedulerWrapper<TaskScheduler> taskScheduler) {
        return new PollingConfigMapChangeDetector(environment, properties, strategy, KubernetesClientConfigMapPropertySource.class, (PropertySourceLocator)configMapPropertySourceLocator, taskScheduler.getTaskScheduler());
    }

    @Bean
    @ConditionalOnSecretsReloadEnabled
    @ConditionalOnBean(value={KubernetesClientSecretsPropertySourceLocator.class})
    @Conditional(value={PollingReloadDetectionMode.class})
    public ConfigurationChangeDetector secretsPropertyChangePollingWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator, AbstractEnvironment environment, TaskSchedulerWrapper<TaskScheduler> taskScheduler) {
        return new PollingSecretsChangeDetector(environment, properties, strategy, KubernetesClientSecretsPropertySource.class, (PropertySourceLocator)secretsPropertySourceLocator, taskScheduler.getTaskScheduler());
    }

    @Bean
    @ConditionalOnConfigMapsReloadEnabled
    @ConditionalOnBean(value={KubernetesClientConfigMapPropertySourceLocator.class})
    @Conditional(value={EventReloadDetectionMode.class})
    public ConfigurationChangeDetector configMapPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator, AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new KubernetesClientEventBasedConfigMapChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, configMapPropertySourceLocator, kubernetesNamespaceProvider);
    }

    @Bean
    @ConditionalOnSecretsReloadEnabled
    @ConditionalOnBean(value={KubernetesClientSecretsPropertySourceLocator.class})
    @Conditional(value={EventReloadDetectionMode.class})
    public ConfigurationChangeDetector secretsPropertyChangeEventWatcher(ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator, AbstractEnvironment environment, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
        return new KubernetesClientEventBasedSecretsChangeDetector(coreV1Api, (ConfigurableEnvironment)environment, properties, strategy, secretsPropertySourceLocator, kubernetesNamespaceProvider);
    }
}

