/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.NamespaceResolutionFailedException;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;

public class KubernetesClientSecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private final CoreV1Api coreV1Api;
    private final KubernetesClientProperties kubernetesClientProperties;
    private final KubernetesNamespaceProvider kubernetesNamespaceProvider;

    @Deprecated
    public KubernetesClientSecretsPropertySourceLocator(CoreV1Api coreV1Api, KubernetesClientProperties kubernetesClientProperties, SecretsConfigProperties secretsConfigProperties) {
        super(secretsConfigProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
        this.kubernetesNamespaceProvider = null;
    }

    public KubernetesClientSecretsPropertySourceLocator(CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider, SecretsConfigProperties secretsConfigProperties) {
        super(secretsConfigProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
        this.kubernetesClientProperties = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource, String configurationTarget) {
        String namespace;
        String normalizedNamespace = normalizedSource.getNamespace();
        String secretName = ConfigUtils.getApplicationName((Environment)environment, (String)normalizedSource.getName(), (String)configurationTarget);
        if (StringUtils.hasText((String)normalizedNamespace)) {
            namespace = normalizedNamespace;
            return new KubernetesClientSecretsPropertySource(this.coreV1Api, secretName, namespace, (Environment)environment, normalizedSource.getLabels());
        } else if (this.kubernetesClientProperties != null) {
            if (!StringUtils.hasText((String)this.kubernetesClientProperties.getNamespace())) throw new NamespaceResolutionFailedException("could not resolve namespace in normalized source or KubernetesClientProperties");
            namespace = this.kubernetesClientProperties.getNamespace();
            return new KubernetesClientSecretsPropertySource(this.coreV1Api, secretName, namespace, (Environment)environment, normalizedSource.getLabels());
        } else {
            namespace = KubernetesClientConfigUtils.getApplicationNamespace(normalizedNamespace, "Secret", this.kubernetesNamespaceProvider);
        }
        return new KubernetesClientSecretsPropertySource(this.coreV1Api, secretName, namespace, (Environment)environment, normalizedSource.getLabels());
    }
}

