/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class KubernetesClientSecretsPropertySourceLocator
extends SecretsPropertySourceLocator {
    private CoreV1Api coreV1Api;
    private KubernetesClientProperties kubernetesClientProperties;
    private KubernetesNamespaceProvider kubernetesNamespaceProvider;

    public KubernetesClientSecretsPropertySourceLocator(CoreV1Api coreV1Api, KubernetesClientProperties kubernetesClientProperties, SecretsConfigProperties secretsConfigProperties) {
        super(secretsConfigProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesClientProperties = kubernetesClientProperties;
    }

    public KubernetesClientSecretsPropertySourceLocator(CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider, SecretsConfigProperties secretsConfigProperties) {
        super(secretsConfigProperties);
        this.coreV1Api = coreV1Api;
        this.kubernetesNamespaceProvider = kubernetesNamespaceProvider;
    }

    protected MapPropertySource getPropertySource(ConfigurableEnvironment environment, SecretsConfigProperties.NormalizedSource normalizedSource, String configurationTarget) {
        String fallbackNamespace = this.kubernetesNamespaceProvider != null ? this.kubernetesNamespaceProvider.getNamespace() : this.kubernetesClientProperties.getNamespace();
        return new KubernetesClientSecretsPropertySource(this.coreV1Api, ConfigUtils.getApplicationName((Environment)environment, (String)normalizedSource.getName(), (String)configurationTarget), KubernetesClientConfigUtils.getNamespace(normalizedSource, fallbackNamespace), (Environment)environment, normalizedSource.getLabels());
    }
}

