/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySource;
import org.springframework.core.env.Environment;

public class KubernetesClientConfigMapPropertySource
extends ConfigMapPropertySource {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigMapPropertySource.class);

    public KubernetesClientConfigMapPropertySource(CoreV1Api coreV1Api, String name, String namespace, Environment environment) {
        super(KubernetesClientConfigMapPropertySource.getName((String)name, (String)namespace), KubernetesClientConfigMapPropertySource.asObjectMap(KubernetesClientConfigMapPropertySource.getData(coreV1Api, name, namespace, environment)));
    }

    private static Map<String, Object> getData(CoreV1Api coreV1Api, String name, String namespace, Environment environment) {
        try {
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            if (environment != null) {
                for (String activeProfile : environment.getActiveProfiles()) {
                    names.add(name + "-" + activeProfile);
                }
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            coreV1Api.listNamespacedConfigMap(namespace, null, null, null, null, null, null, null, null, null).getItems().stream().filter(cm -> names.contains(cm.getMetadata().getName())).forEach(map -> result.putAll(KubernetesClientConfigMapPropertySource.processAllEntries((Map)map.getData(), (Environment)environment)));
            return result;
        }
        catch (ApiException e) {
            LOG.warn((Object)("Unable to get ConfigMap " + name + " in namespace " + namespace), (Throwable)e);
            return new LinkedHashMap<String, Object>();
        }
    }
}

