/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.ClientBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class KubernetesClientUtils {
    private static final Log LOG = LogFactory.getLog(KubernetesClientUtils.class);

    private KubernetesClientUtils() {
    }

    public static ApiClient kubernetesApiClient() {
        try {
            ApiClient apiClient = ClientBuilder.cluster().build();
            LOG.info((Object)"Created API client in the cluster.");
            return apiClient;
        }
        catch (Exception e) {
            LOG.info((Object)"Could not create the Kubernetes ApiClient in a cluster environment, because : ", (Throwable)e);
            LOG.info((Object)"Trying to use a \"standard\" configuration to create the Kubernetes ApiClient");
            try {
                ApiClient apiClient = ClientBuilder.defaultClient();
                LOG.info((Object)"Created standard API client. Unless $KUBECONFIG or $HOME/.kube/config is defined, this client will try to connect to localhost:8080");
                return apiClient;
            }
            catch (Exception e1) {
                LOG.warn((Object)"Could not create a Kubernetes ApiClient from either a cluster or standard environment. Will return one that always connects to localhost:8080", (Throwable)e1);
                return new ClientBuilder().build();
            }
        }
    }
}

