/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.secretmanager;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.secretmanager.v1beta1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1beta1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.CreateSecretRequest;
import com.google.cloud.secretmanager.v1beta1.ProjectName;
import com.google.cloud.secretmanager.v1beta1.Replication;
import com.google.cloud.secretmanager.v1beta1.Secret;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretName;
import com.google.cloud.secretmanager.v1beta1.SecretPayload;
import com.google.cloud.secretmanager.v1beta1.SecretVersionName;
import com.google.protobuf.ByteString;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.secretmanager.SecretManagerOperations;

public class SecretManagerTemplate
implements SecretManagerOperations {
    private final SecretManagerServiceClient secretManagerServiceClient;
    private final GcpProjectIdProvider projectIdProvider;

    public SecretManagerTemplate(SecretManagerServiceClient secretManagerServiceClient, GcpProjectIdProvider projectIdProvider) {
        this.secretManagerServiceClient = secretManagerServiceClient;
        this.projectIdProvider = projectIdProvider;
    }

    @Override
    public void createSecret(String secretId, String payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFromUtf8((String)payload));
    }

    @Override
    public void createSecret(String secretId, byte[] payload) {
        this.createNewSecretVersion(secretId, ByteString.copyFrom((byte[])payload));
    }

    @Override
    public String getSecretString(String secretId) {
        return this.getSecretString(secretId, "latest");
    }

    @Override
    public String getSecretString(String secretId, String versionName) {
        return this.getSecretByteString(secretId, versionName).toStringUtf8();
    }

    @Override
    public byte[] getSecretBytes(String secretId) {
        return this.getSecretBytes(secretId, "latest");
    }

    @Override
    public byte[] getSecretBytes(String secretId, String versionName) {
        return this.getSecretByteString(secretId, versionName).toByteArray();
    }

    @Override
    public ByteString getSecretByteString(String secretId, String versionName) {
        SecretVersionName secretVersionName = SecretVersionName.of((String)this.projectIdProvider.getProjectId(), (String)secretId, (String)versionName);
        AccessSecretVersionResponse response = this.secretManagerServiceClient.accessSecretVersion(secretVersionName);
        return response.getPayload().getData();
    }

    @Override
    public boolean secretExists(String secretId) {
        SecretName secretName = SecretName.of((String)this.projectIdProvider.getProjectId(), (String)secretId);
        try {
            this.secretManagerServiceClient.getSecret(secretName);
        }
        catch (NotFoundException ex) {
            return false;
        }
        return true;
    }

    private void createNewSecretVersion(String secretId, ByteString payload) {
        if (!this.secretExists(secretId)) {
            this.createSecret(secretId);
        }
        SecretName name = SecretName.of((String)this.projectIdProvider.getProjectId(), (String)secretId);
        AddSecretVersionRequest payloadRequest = AddSecretVersionRequest.newBuilder().setParent(name.toString()).setPayload(SecretPayload.newBuilder().setData(payload)).build();
        this.secretManagerServiceClient.addSecretVersion(payloadRequest);
    }

    private void createSecret(String secretId) {
        ProjectName projectName = ProjectName.of((String)this.projectIdProvider.getProjectId());
        Secret secret = Secret.newBuilder().setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.getDefaultInstance())).build();
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(projectName.toString()).setSecretId(secretId).setSecret(secret).build();
        this.secretManagerServiceClient.createSecret(request);
    }
}

