/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.support;

import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PubsubMessage;

public class AcknowledgeablePubsubMessage {
    private PubsubMessage message;
    private String ackId;
    private String subscriptionName;
    private SubscriberStub subscriberStub;

    public AcknowledgeablePubsubMessage(PubsubMessage message, String ackId, String subscriptionName, SubscriberStub subscriberStub) {
        this.message = message;
        this.ackId = ackId;
        this.subscriptionName = subscriptionName;
        this.subscriberStub = subscriberStub;
    }

    public PubsubMessage getPubsubMessage() {
        return this.message;
    }

    public String getAckId() {
        return this.ackId;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void ack() {
        AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().addAckIds(this.ackId).setSubscription(this.subscriptionName).build();
        this.subscriberStub.acknowledgeCallable().call((Object)acknowledgeRequest);
    }

    public void nack() {
        ModifyAckDeadlineRequest modifyAckDeadlineRequest = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(0).addAckIds(this.ackId).setSubscription(this.subscriptionName).build();
        this.subscriberStub.modifyAckDeadlineCallable().call((Object)modifyAckDeadlineRequest);
    }
}

