/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.integration;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.util.PatternMatchUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public class PubSubHeaderMapper
implements HeaderMapper<Map<String, String>> {
    private String[] outboundHeaderPatterns = new String[]{"!id", "!timestamp", "!gcp_pubsub_acknowledgement", "!nativeHeaders", "*"};
    private String[] inboundHeaderPatterns = new String[]{"*"};

    public void setOutboundHeaderPatterns(String ... outboundHeaderPatterns) {
        Assert.notNull((Object)outboundHeaderPatterns, (String)"Header patterns can't be null.");
        Assert.noNullElements((Object[])outboundHeaderPatterns, (String)"No header pattern can be null.");
        this.outboundHeaderPatterns = Arrays.copyOf(outboundHeaderPatterns, outboundHeaderPatterns.length);
    }

    public void setInboundHeaderPatterns(String ... inboundHeaderPatterns) {
        Assert.notNull((Object)inboundHeaderPatterns, (String)"Header patterns can't be null.");
        Assert.noNullElements((Object[])inboundHeaderPatterns, (String)"No header pattern can be null.");
        this.inboundHeaderPatterns = Arrays.copyOf(inboundHeaderPatterns, inboundHeaderPatterns.length);
    }

    public void fromHeaders(MessageHeaders messageHeaders, Map<String, String> pubsubMessageHeaders) {
        messageHeaders.entrySet().stream().filter(entry -> Boolean.TRUE.equals(PatternMatchUtils.smartMatch((String)((String)entry.getKey()), (String[])this.outboundHeaderPatterns))).forEach(entry -> pubsubMessageHeaders.put((String)entry.getKey(), entry.getValue().toString()));
    }

    public Map<String, Object> toHeaders(Map<String, String> pubsubMessageHeaders) {
        return pubsubMessageHeaders.entrySet().stream().filter(entry -> Boolean.TRUE.equals(PatternMatchUtils.smartMatch((String)((String)entry.getKey()), (String[])this.inboundHeaderPatterns))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

