/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.stream.binder.pubsub.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubBindingProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubConsumerProperties;
import org.springframework.cloud.gcp.stream.binder.pubsub.properties.PubSubProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;

@ConfigurationProperties(value="spring.cloud.stream.gcp.pubsub")
public class PubSubExtendedBindingProperties
implements ExtendedBindingProperties<PubSubConsumerProperties, PubSubProducerProperties> {
    private Map<String, PubSubBindingProperties> bindings = new HashMap<String, PubSubBindingProperties>();

    public Map<String, PubSubBindingProperties> getBindings() {
        return this.bindings;
    }

    public PubSubConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getConsumer() != null) {
            return this.bindings.get(channelName).getConsumer();
        }
        return new PubSubConsumerProperties();
    }

    public PubSubProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getProducer() != null) {
            return this.bindings.get(channelName).getProducer();
        }
        return new PubSubProducerProperties();
    }
}

