/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerQueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

abstract class AbstractSpannerQuery<T>
implements RepositoryQuery {
    protected final SpannerQueryMethod queryMethod;
    protected final SpannerTemplate spannerTemplate;
    protected final SpannerMappingContext spannerMappingContext;
    protected final Class<T> entityType;

    AbstractSpannerQuery(Class<T> type, SpannerQueryMethod queryMethod, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        this.queryMethod = queryMethod;
        this.entityType = type;
        this.spannerTemplate = spannerTemplate;
        this.spannerMappingContext = spannerMappingContext;
    }

    public Object execute(Object[] parameters) {
        List results = this.executeRawResult(parameters);
        Class<?> simpleConvertedType = this.getReturnedSimpleConvertableItemType();
        if (simpleConvertedType != null) {
            return this.convertToSimpleReturnType(results, simpleConvertedType);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.applyProjection(results);
        }
        return results == null || results.isEmpty() ? null : this.queryMethod.getResultProcessor().processResult(results.get(0));
    }

    Object convertToSimpleReturnType(List<?> results, Class<?> simpleConvertedType) {
        return this.queryMethod.isCollectionQuery() ? results.stream().map(x -> this.spannerTemplate.getSpannerEntityProcessor().getReadConverter().convert(x, simpleConvertedType)).collect(Collectors.toList()) : this.spannerTemplate.getSpannerEntityProcessor().getReadConverter().convert(this.getFirstElementOrNull(results), simpleConvertedType);
    }

    private Object getFirstElementOrNull(List<?> results) {
        return !results.isEmpty() ? results.get(0) : null;
    }

    Class<?> getReturnedType() {
        return this.queryMethod.isCollectionQuery() ? this.queryMethod.getResultProcessor().getReturnedType().getReturnedType() : this.queryMethod.getReturnedObjectType();
    }

    Class<?> getReturnedSimpleConvertableItemType() {
        Class<?> itemType = this.getReturnedType();
        return itemType == Void.TYPE ? null : this.spannerTemplate.getSpannerEntityProcessor().getCorrespondingSpannerJavaType(itemType, false);
    }

    Object processRawObjectForProjection(Object object) {
        return this.queryMethod.getResultProcessor().processResult(object);
    }

    public SpannerQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private List applyProjection(List<T> rawResult) {
        if (rawResult == null) {
            return Collections.emptyList();
        }
        return rawResult.stream().map(this::processRawObjectForProjection).collect(Collectors.toList());
    }

    protected abstract List executeRawResult(Object[] var1);
}

