/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConverterAwareMappingSpannerEntityReader;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConverterAwareMappingSpannerEntityWriter;
import org.springframework.cloud.gcp.data.spanner.core.convert.MultipleValueBinder;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityProcessor;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerReadConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerWriteConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.StructAccessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class ConverterAwareMappingSpannerEntityProcessor
implements SpannerEntityProcessor {
    private final ConverterAwareMappingSpannerEntityReader entityReader;
    private final ConverterAwareMappingSpannerEntityWriter entityWriter;
    private final SpannerReadConverter readConverter;
    private final SpannerWriteConverter writeConverter;

    public ConverterAwareMappingSpannerEntityProcessor(SpannerMappingContext spannerMappingContext) {
        this(spannerMappingContext, null, null);
    }

    public ConverterAwareMappingSpannerEntityProcessor(SpannerMappingContext spannerMappingContext, Collection<Converter> writeConverters, Collection<Converter> readConverters) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Spanner is required.");
        this.readConverter = new SpannerReadConverter(readConverters);
        this.entityReader = new ConverterAwareMappingSpannerEntityReader(spannerMappingContext, this.readConverter);
        this.writeConverter = new SpannerWriteConverter(writeConverters);
        this.entityWriter = new ConverterAwareMappingSpannerEntityWriter(spannerMappingContext, this.writeConverter);
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass) {
        return this.mapToList(resultSet, entityClass, null, false);
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass, Set<String> includeColumns, boolean allowMissingColumns) {
        ArrayList<T> result = new ArrayList<T>();
        while (resultSet.next()) {
            result.add(this.entityReader.read(entityClass, resultSet.getCurrentRowAsStruct(), includeColumns, allowMissingColumns));
        }
        resultSet.close();
        return result;
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass, String ... includeColumns) {
        return this.mapToList(resultSet, entityClass, (Set<String>)(includeColumns.length == 0 ? null : new HashSet<String>(Arrays.asList(includeColumns))), false);
    }

    @Override
    public Class<?> getCorrespondingSpannerJavaType(Class originalType, boolean isIterableInnerType) {
        Class<?> compatible;
        if (isIterableInnerType) {
            if (ConverterAwareMappingSpannerEntityWriter.iterablePropertyTypeToMethodMap.keySet().contains(originalType)) {
                return originalType;
            }
            compatible = ConverterAwareMappingSpannerEntityWriter.findFirstCompatibleSpannerMultipleItemNativeType(spannerType -> this.canHandlePropertyTypeForArrayRead(originalType, (Class)spannerType) && this.writeConverter.canConvert(originalType, (Class<?>)spannerType));
        } else {
            if (ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.keySet().contains(originalType)) {
                return originalType;
            }
            compatible = ConverterAwareMappingSpannerEntityWriter.findFirstCompatibleSpannerSingleItemNativeType(spannerType -> this.canHandlePropertyTypeForSingularRead(originalType, (Class)spannerType) && this.writeConverter.canConvert(originalType, (Class<?>)spannerType));
        }
        return compatible;
    }

    private boolean canHandlePropertyTypeForSingularRead(Class type, Class spannerSupportedType) {
        if (!StructAccessor.singleItemReadMethodMapping.containsKey(spannerSupportedType)) {
            throw new SpannerDataException("The given spannerSupportedType type is not a known Spanner directly-supported column type: " + spannerSupportedType);
        }
        return type.equals(spannerSupportedType) || this.readConverter.canConvert(spannerSupportedType, type);
    }

    private boolean canHandlePropertyTypeForArrayRead(Class type, Class spannerSupportedArrayInnerType) {
        if (!StructAccessor.readIterableMapping.containsKey(spannerSupportedArrayInnerType)) {
            throw new SpannerDataException("The given spannerSupportedArrayInnerType is not a known Spanner directly-supported array column inner-type: " + spannerSupportedArrayInnerType);
        }
        return type.equals(spannerSupportedArrayInnerType) || this.readConverter.canConvert(spannerSupportedArrayInnerType, type);
    }

    public void write(Object source, MultipleValueBinder sink) {
        this.entityWriter.write(source, sink);
    }

    @Override
    public void write(Object source, MultipleValueBinder sink, Set<String> includeColumns) {
        this.entityWriter.write(source, sink, includeColumns);
    }

    @Override
    public Key convertToKey(Object key) {
        return this.entityWriter.convertToKey(key);
    }

    @Override
    public SpannerWriteConverter getSpannerWriteConverter() {
        return this.entityWriter.getSpannerWriteConverter();
    }

    @Override
    public <R> R read(Class<R> type, Struct source, Set<String> includeColumns, boolean allowMissingColumns) {
        return this.entityReader.read(type, source, includeColumns, allowMissingColumns);
    }

    @Override
    public SpannerWriteConverter getWriteConverter() {
        return this.writeConverter;
    }

    @Override
    public SpannerReadConverter getReadConverter() {
        return this.readConverter;
    }
}

