/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.bigquery.core;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatus;
import com.google.cloud.bigquery.TableDataWriteChannel;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.WriteChannelConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import org.springframework.cloud.gcp.bigquery.core.BigQueryException;
import org.springframework.cloud.gcp.bigquery.core.BigQueryOperations;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.DefaultManagedTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class BigQueryTemplate
implements BigQueryOperations {
    private final BigQuery bigQuery;
    private final String datasetName;
    private final TaskScheduler taskScheduler;
    private boolean autoDetectSchema = true;
    private JobInfo.WriteDisposition writeDisposition = JobInfo.WriteDisposition.WRITE_APPEND;
    private Duration jobPollInterval = Duration.ofSeconds(2L);

    public BigQueryTemplate(BigQuery bigQuery, String datasetName) {
        this(bigQuery, datasetName, (TaskScheduler)new DefaultManagedTaskScheduler());
    }

    public BigQueryTemplate(BigQuery bigQuery, String datasetName, TaskScheduler taskScheduler) {
        Assert.notNull((Object)bigQuery, (String)"BigQuery client object must not be null.");
        Assert.notNull((Object)datasetName, (String)"Dataset name must not be null");
        Assert.notNull((Object)taskScheduler, (String)"TaskScheduler must not be null");
        this.bigQuery = bigQuery;
        this.datasetName = datasetName;
        this.taskScheduler = taskScheduler;
    }

    public void setAutoDetectSchema(boolean autoDetectSchema) {
        this.autoDetectSchema = autoDetectSchema;
    }

    public void setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
        Assert.notNull((Object)writeDisposition, (String)"BigQuery write disposition must not be null.");
        this.writeDisposition = writeDisposition;
    }

    public void setJobPollInterval(Duration jobPollInterval) {
        Assert.notNull((Object)jobPollInterval, (String)"BigQuery job polling interval must not be null");
        this.jobPollInterval = jobPollInterval;
    }

    @Override
    public ListenableFuture<Job> writeDataToTable(String tableName, InputStream inputStream, FormatOptions dataFormatOptions) {
        TableId tableId = TableId.of((String)this.datasetName, (String)tableName);
        WriteChannelConfiguration writeChannelConfiguration = WriteChannelConfiguration.newBuilder((TableId)tableId).setFormatOptions(dataFormatOptions).setAutodetect(Boolean.valueOf(this.autoDetectSchema)).setWriteDisposition(this.writeDisposition).build();
        TableDataWriteChannel writer = this.bigQuery.writer(writeChannelConfiguration);
        try (OutputStream sink = Channels.newOutputStream((WritableByteChannel)writer);){
            StreamUtils.copy((InputStream)inputStream, (OutputStream)sink);
        }
        catch (IOException e) {
            throw new BigQueryException("Failed to write data to BigQuery tables.", e);
        }
        if (writer.getJob() == null) {
            throw new BigQueryException("Failed to initialize the BigQuery write job.");
        }
        return this.createJobFuture(writer.getJob());
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    private SettableListenableFuture<Job> createJobFuture(Job pendingJob) {
        SettableListenableFuture result = new SettableListenableFuture();
        ScheduledFuture scheduledFuture = this.taskScheduler.scheduleAtFixedRate(() -> {
            Job job = pendingJob.reload(new BigQuery.JobOption[0]);
            if (JobStatus.State.DONE.equals((Object)job.getStatus().getState())) {
                if (job.getStatus().getError() != null) {
                    result.setException((Throwable)((Object)new BigQueryException(job.getStatus().getError().getMessage())));
                } else {
                    result.set((Object)job);
                }
            }
        }, this.jobPollInterval);
        result.addCallback(response -> scheduledFuture.cancel(true), response -> {
            pendingJob.cancel();
            scheduledFuture.cancel(true);
        });
        return result;
    }
}

