/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.security;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.core.GcpContextAutoConfiguration;
import org.springframework.cloud.gcp.autoconfigure.core.environment.ConditionalOnGcpEnvironment;
import org.springframework.cloud.gcp.autoconfigure.security.IapAuthenticationProperties;
import org.springframework.cloud.gcp.core.GcpEnvironment;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.security.iap.AppEngineAudienceProvider;
import org.springframework.cloud.gcp.security.iap.AudienceProvider;
import org.springframework.cloud.gcp.security.iap.AudienceValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;
import org.springframework.security.oauth2.jwt.JwtTimestampValidator;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.gcp.security.iap.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AudienceValidator.class})
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
@AutoConfigureAfter(value={GcpContextAutoConfiguration.class})
@EnableConfigurationProperties(value={IapAuthenticationProperties.class})
public class IapAuthenticationAutoConfiguration {
    private static final Log LOGGER = LogFactory.getLog(IapAuthenticationAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public BearerTokenResolver iatTokenResolver(IapAuthenticationProperties properties) {
        return r -> r.getHeader(properties.getHeader());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.gcp.security.iap.audience"})
    public AudienceProvider propertyBasedAudienceProvider(IapAuthenticationProperties properties) {
        return properties::getAudience;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnGcpEnvironment(value={GcpEnvironment.APP_ENGINE_FLEXIBLE, GcpEnvironment.APP_ENGINE_STANDARD})
    public AudienceProvider appEngineBasedAudienceProvider(GcpProjectIdProvider projectIdProvider) {
        return new AppEngineAudienceProvider(projectIdProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public AudienceValidator audienceValidator(AudienceProvider audienceProvider) {
        return new AudienceValidator(audienceProvider);
    }

    @Bean
    @ConditionalOnMissingBean(name={"iapJwtDelegatingValidator"})
    public DelegatingOAuth2TokenValidator<Jwt> iapJwtDelegatingValidator(IapAuthenticationProperties properties, AudienceValidator audienceValidator) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(new JwtTimestampValidator());
        validators.add(new JwtIssuerValidator(properties.getIssuer()));
        validators.add(audienceValidator);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Audience configured for IAP JWT validation: " + audienceValidator.getAudience()));
        }
        return new DelegatingOAuth2TokenValidator(validators);
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtDecoder iapJwtDecoder(IapAuthenticationProperties properties, @Qualifier(value="iapJwtDelegatingValidator") DelegatingOAuth2TokenValidator<Jwt> validator) {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)properties.getRegistry()).jwsAlgorithm(SignatureAlgorithm.from((String)properties.getAlgorithm())).build();
        jwtDecoder.setJwtValidator(validator);
        return jwtDecoder;
    }
}

