/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.sql;

import org.springframework.cloud.gcp.autoconfigure.sql.CloudSqlJdbcInfoProvider;
import org.springframework.cloud.gcp.autoconfigure.sql.DatabaseType;
import org.springframework.cloud.gcp.autoconfigure.sql.GcpCloudSqlProperties;
import org.springframework.util.Assert;

public class DefaultCloudSqlJdbcInfoProvider
implements CloudSqlJdbcInfoProvider {
    private final GcpCloudSqlProperties properties;
    private final DatabaseType databaseType;

    public DefaultCloudSqlJdbcInfoProvider(GcpCloudSqlProperties properties, DatabaseType databaseType) {
        this.properties = properties;
        this.databaseType = databaseType;
        Assert.hasText((String)this.properties.getDatabaseName(), (String)"A database name must be provided.");
        Assert.hasText((String)properties.getInstanceConnectionName(), (String)"An instance connection name must be provided in the format <PROJECT_ID>:<REGION>:<INSTANCE_ID>.");
    }

    @Override
    public String getJdbcDriverClass() {
        return this.databaseType.getJdbcDriverName();
    }

    @Override
    public String getJdbcUrl() {
        return String.format(this.databaseType.getJdbcUrlTemplate(), this.properties.getDatabaseName(), this.properties.getInstanceConnectionName());
    }
}

